package org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ConfigType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ConfigFileType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.ConfigFileTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ConfigFileType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.ConfigFileTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ConfigFileType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.ConfigFileTypeImpl;

/**
 * This class implements the <code> config-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ConfigTypeImpl<T> implements Child<T>, ConfigType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ConfigTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ConfigTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigType ElementName: wildfly:config-file-type ElementType : standalone
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>standalone</code> element will be created and returned.
    * Otherwise, the first existing <code>standalone</code> element will be returned.
    * @return the instance defined for the element <code>standalone</code> 
    */
   public ConfigFileType<ConfigType<T>> getOrCreateStandalone()
   {
      List<Node> nodeList = childNode.get("standalone");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ConfigFileTypeImpl<ConfigType<T>>(this, "standalone", childNode, nodeList.get(0));
      }
      return createStandalone();
   }

   /**
    * Creates a new <code>standalone</code> element 
    * @return the new created instance of <code>ConfigFileType<ConfigType<T>></code> 
    */
   public ConfigFileType<ConfigType<T>> createStandalone()
   {
      return new ConfigFileTypeImpl<ConfigType<T>>(this, "standalone", childNode);
   }

   /**
    * Returns all <code>standalone</code> elements
    * @return list of <code>standalone</code> 
    */
   public List<ConfigFileType<ConfigType<T>>> getAllStandalone()
   {
      List<ConfigFileType<ConfigType<T>>> list = new ArrayList<ConfigFileType<ConfigType<T>>>();
      List<Node> nodeList = childNode.get("standalone");
      for(Node node: nodeList)
      {
         ConfigFileType<ConfigType<T>>  type = new ConfigFileTypeImpl<ConfigType<T>>(this, "standalone", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>standalone</code> elements 
    * @return the current instance of <code>ConfigFileType<ConfigType<T>></code> 
    */
   public ConfigType<T> removeAllStandalone()
   {
      childNode.removeChildren("standalone");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigType ElementName: wildfly:config-file-type ElementType : domain
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>domain</code> element will be created and returned.
    * Otherwise, the first existing <code>domain</code> element will be returned.
    * @return the instance defined for the element <code>domain</code> 
    */
   public ConfigFileType<ConfigType<T>> getOrCreateDomain()
   {
      List<Node> nodeList = childNode.get("domain");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ConfigFileTypeImpl<ConfigType<T>>(this, "domain", childNode, nodeList.get(0));
      }
      return createDomain();
   }

   /**
    * Creates a new <code>domain</code> element 
    * @return the new created instance of <code>ConfigFileType<ConfigType<T>></code> 
    */
   public ConfigFileType<ConfigType<T>> createDomain()
   {
      return new ConfigFileTypeImpl<ConfigType<T>>(this, "domain", childNode);
   }

   /**
    * Returns all <code>domain</code> elements
    * @return list of <code>domain</code> 
    */
   public List<ConfigFileType<ConfigType<T>>> getAllDomain()
   {
      List<ConfigFileType<ConfigType<T>>> list = new ArrayList<ConfigFileType<ConfigType<T>>>();
      List<Node> nodeList = childNode.get("domain");
      for(Node node: nodeList)
      {
         ConfigFileType<ConfigType<T>>  type = new ConfigFileTypeImpl<ConfigType<T>>(this, "domain", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>domain</code> elements 
    * @return the current instance of <code>ConfigFileType<ConfigType<T>></code> 
    */
   public ConfigType<T> removeAllDomain()
   {
      childNode.removeChildren("domain");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigType ElementName: wildfly:config-file-type ElementType : host
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>host</code> element will be created and returned.
    * Otherwise, the first existing <code>host</code> element will be returned.
    * @return the instance defined for the element <code>host</code> 
    */
   public ConfigFileType<ConfigType<T>> getOrCreateHost()
   {
      List<Node> nodeList = childNode.get("host");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new ConfigFileTypeImpl<ConfigType<T>>(this, "host", childNode, nodeList.get(0));
      }
      return createHost();
   }

   /**
    * Creates a new <code>host</code> element 
    * @return the new created instance of <code>ConfigFileType<ConfigType<T>></code> 
    */
   public ConfigFileType<ConfigType<T>> createHost()
   {
      return new ConfigFileTypeImpl<ConfigType<T>>(this, "host", childNode);
   }

   /**
    * Returns all <code>host</code> elements
    * @return list of <code>host</code> 
    */
   public List<ConfigFileType<ConfigType<T>>> getAllHost()
   {
      List<ConfigFileType<ConfigType<T>>> list = new ArrayList<ConfigFileType<ConfigType<T>>>();
      List<Node> nodeList = childNode.get("host");
      for(Node node: nodeList)
      {
         ConfigFileType<ConfigType<T>>  type = new ConfigFileTypeImpl<ConfigType<T>>(this, "host", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>host</code> elements 
    * @return the current instance of <code>ConfigFileType<ConfigType<T>></code> 
    */
   public ConfigType<T> removeAllHost()
   {
      childNode.removeChildren("host");
      return this;
   }
}
