package org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.DependenciesType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.NamedType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.NamedTypeImpl;

/**
 * This class implements the <code> dependencies-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class DependenciesTypeImpl<T> implements Child<T>, DependenciesType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public DependenciesTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public DependenciesTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DependenciesType ElementName: wildfly:named-type ElementType : artifact
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>artifact</code> element will be created and returned.
    * Otherwise, the first existing <code>artifact</code> element will be returned.
    * @return the instance defined for the element <code>artifact</code> 
    */
   public NamedType<DependenciesType<T>> getOrCreateArtifact()
   {
      List<Node> nodeList = childNode.get("artifact");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new NamedTypeImpl<DependenciesType<T>>(this, "artifact", childNode, nodeList.get(0));
      }
      return createArtifact();
   }

   /**
    * Creates a new <code>artifact</code> element 
    * @return the new created instance of <code>NamedType<DependenciesType<T>></code> 
    */
   public NamedType<DependenciesType<T>> createArtifact()
   {
      return new NamedTypeImpl<DependenciesType<T>>(this, "artifact", childNode);
   }

   /**
    * Returns all <code>artifact</code> elements
    * @return list of <code>artifact</code> 
    */
   public List<NamedType<DependenciesType<T>>> getAllArtifact()
   {
      List<NamedType<DependenciesType<T>>> list = new ArrayList<NamedType<DependenciesType<T>>>();
      List<Node> nodeList = childNode.get("artifact");
      for(Node node: nodeList)
      {
         NamedType<DependenciesType<T>>  type = new NamedTypeImpl<DependenciesType<T>>(this, "artifact", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>artifact</code> elements 
    * @return the current instance of <code>NamedType<DependenciesType<T>></code> 
    */
   public DependenciesType<T> removeAllArtifact()
   {
      childNode.removeChildren("artifact");
      return this;
   }
}
