package org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.FilePermissionsType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.FilePermissionType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.FilePermissionTypeImpl;

/**
 * This class implements the <code> file-permissions-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class FilePermissionsTypeImpl<T> implements Child<T>, FilePermissionsType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public FilePermissionsTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public FilePermissionsTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: FilePermissionsType ElementName: wildfly:file-permission-type ElementType : permission
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>permission</code> element will be created and returned.
    * Otherwise, the first existing <code>permission</code> element will be returned.
    * @return the instance defined for the element <code>permission</code> 
    */
   public FilePermissionType<FilePermissionsType<T>> getOrCreatePermission()
   {
      List<Node> nodeList = childNode.get("permission");
      if (nodeList != null &&  nodeList.size() > 0)
      {
         return new FilePermissionTypeImpl<FilePermissionsType<T>>(this, "permission", childNode, nodeList.get(0));
      }
      return createPermission();
   }

   /**
    * Creates a new <code>permission</code> element 
    * @return the new created instance of <code>FilePermissionType<FilePermissionsType<T>></code> 
    */
   public FilePermissionType<FilePermissionsType<T>> createPermission()
   {
      return new FilePermissionTypeImpl<FilePermissionsType<T>>(this, "permission", childNode);
   }

   /**
    * Returns all <code>permission</code> elements
    * @return list of <code>permission</code> 
    */
   public List<FilePermissionType<FilePermissionsType<T>>> getAllPermission()
   {
      List<FilePermissionType<FilePermissionsType<T>>> list = new ArrayList<FilePermissionType<FilePermissionsType<T>>>();
      List<Node> nodeList = childNode.get("permission");
      for(Node node: nodeList)
      {
         FilePermissionType<FilePermissionsType<T>>  type = new FilePermissionTypeImpl<FilePermissionsType<T>>(this, "permission", childNode, node);
         list.add(type);
      }
      return list;
   }

   /**
    * Removes all <code>permission</code> elements 
    * @return the current instance of <code>FilePermissionType<FilePermissionsType<T>></code> 
    */
   public FilePermissionsType<T> removeAllPermission()
   {
      childNode.removeChildren("permission");
      return this;
   }
}
