package org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11; 

import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.WildFlyFeaturePackDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.DependenciesType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.DependenciesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ArtifactVersionsType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.ArtifactVersionsTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ConfigType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.ConfigTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.CopyArtifactsType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.CopyArtifactsTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.FilePermissionsType;
import org.jboss.shrinkwrap.descriptor.impl.wildflyfeaturepack11.FilePermissionsTypeImpl;
import java.util.Map.Entry;

import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

import org.jboss.shrinkwrap.descriptor.spi.node.NodeDescriptorImplBase;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     WildFlyFeaturePackDescriptor descriptor = Descriptors.create(WildFlyFeaturePackDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class WildFlyFeaturePackDescriptorImpl extends NodeDescriptorImplBase implements DescriptorNamespace<WildFlyFeaturePackDescriptor>, WildFlyFeaturePackDescriptor
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private Node model;

   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public WildFlyFeaturePackDescriptorImpl(String descriptorName)
   {
       this(descriptorName, new Node("feature-pack"));
   }

   public WildFlyFeaturePackDescriptorImpl(String descriptorName, Node node)
   {
      super(descriptorName);
      this.model = node;
      addDefaultNamespaces();
   }

   // -------------------------------------------------------------------------------------||
   // Methods 
   // -------------------------------------------------------------------------------------||

   public Node getRootNode()
   {
      return model;
   }



   // -------------------------------------------------------------------------------------||
   // Namespace 
   // -------------------------------------------------------------------------------------||


   /**
    * Adds the default namespaces as defined in the specification 
    * @return the current instance of <code>WildFlyFeaturePackDescriptor</code> 
    */
   public WildFlyFeaturePackDescriptor addDefaultNamespaces()
   {
      addNamespace("xmlns", "urn:wildfly:feature-pack:1.1");
     return this;
   }

   /**
    * Adds a new namespace 
    * @return the current instance of <code>WildFlyFeaturePackDescriptor</code> 
    */
   public WildFlyFeaturePackDescriptor addNamespace(String name, String value)
   {
      model.attribute(name, value);
      return this;
   }

   /**
    * Returns all defined namespaces. 
    * @return all defined namespaces 
    */
   public List<String> getNamespaces()
   {
      List<String> namespaceList = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            namespaceList.add(name + "=" + value);
         }
      }
      return namespaceList;
   }

   /**
    * Removes all existing namespaces. 
    * @return the current instance of <code>WildFlyFeaturePackDescriptor</code> 
    */
   public WildFlyFeaturePackDescriptor removeAllNamespaces()
   {
      List<String> nameSpaceKeys = new ArrayList<String>();
      java.util.Map<String, String> attributes = model.getAttributes();
      for (Entry<String, String> e : attributes.entrySet())
      {
         final String name = e.getKey();
         final String value = e.getValue();
         if (value != null && value.startsWith("http://")) 
         {
            nameSpaceKeys.add(name);
         }
      }
      for (String name: nameSpaceKeys)
      {
         model.removeAttribute(name);
      }
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WildFlyFeaturePackDescriptor ElementName: wildfly:dependencies-type ElementType : dependencies
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<WildFlyFeaturePackDescriptor></code> 
    */
   public DependenciesType<WildFlyFeaturePackDescriptor> getOrCreateDependencies()
   {
      Node node = model.getOrCreate("dependencies");
      DependenciesType<WildFlyFeaturePackDescriptor> dependencies = new DependenciesTypeImpl<WildFlyFeaturePackDescriptor>(this, "dependencies", model, node);
      return dependencies;
   }

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>WildFlyFeaturePackDescriptor</code> 
    */
   public WildFlyFeaturePackDescriptor removeDependencies()
   {
      model.removeChildren("dependencies");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WildFlyFeaturePackDescriptor ElementName: wildfly:artifact-versions-type ElementType : artifact-versions
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>artifact-versions</code> element with the given value will be created.
    * Otherwise, the existing <code>artifact-versions</code> element will be returned.
    * @return  a new or existing instance of <code>ArtifactVersionsType<WildFlyFeaturePackDescriptor></code> 
    */
   public ArtifactVersionsType<WildFlyFeaturePackDescriptor> getOrCreateArtifactVersions()
   {
      Node node = model.getOrCreate("artifact-versions");
      ArtifactVersionsType<WildFlyFeaturePackDescriptor> artifactVersions = new ArtifactVersionsTypeImpl<WildFlyFeaturePackDescriptor>(this, "artifact-versions", model, node);
      return artifactVersions;
   }

   /**
    * Removes the <code>artifact-versions</code> element 
    * @return the current instance of <code>WildFlyFeaturePackDescriptor</code> 
    */
   public WildFlyFeaturePackDescriptor removeArtifactVersions()
   {
      model.removeChildren("artifact-versions");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WildFlyFeaturePackDescriptor ElementName: wildfly:config-type ElementType : config
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>config</code> element with the given value will be created.
    * Otherwise, the existing <code>config</code> element will be returned.
    * @return  a new or existing instance of <code>ConfigType<WildFlyFeaturePackDescriptor></code> 
    */
   public ConfigType<WildFlyFeaturePackDescriptor> getOrCreateConfig()
   {
      Node node = model.getOrCreate("config");
      ConfigType<WildFlyFeaturePackDescriptor> config = new ConfigTypeImpl<WildFlyFeaturePackDescriptor>(this, "config", model, node);
      return config;
   }

   /**
    * Removes the <code>config</code> element 
    * @return the current instance of <code>WildFlyFeaturePackDescriptor</code> 
    */
   public WildFlyFeaturePackDescriptor removeConfig()
   {
      model.removeChildren("config");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WildFlyFeaturePackDescriptor ElementName: wildfly:copy-artifacts-type ElementType : copy-artifacts
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>copy-artifacts</code> element with the given value will be created.
    * Otherwise, the existing <code>copy-artifacts</code> element will be returned.
    * @return  a new or existing instance of <code>CopyArtifactsType<WildFlyFeaturePackDescriptor></code> 
    */
   public CopyArtifactsType<WildFlyFeaturePackDescriptor> getOrCreateCopyArtifacts()
   {
      Node node = model.getOrCreate("copy-artifacts");
      CopyArtifactsType<WildFlyFeaturePackDescriptor> copyArtifacts = new CopyArtifactsTypeImpl<WildFlyFeaturePackDescriptor>(this, "copy-artifacts", model, node);
      return copyArtifacts;
   }

   /**
    * Removes the <code>copy-artifacts</code> element 
    * @return the current instance of <code>WildFlyFeaturePackDescriptor</code> 
    */
   public WildFlyFeaturePackDescriptor removeCopyArtifacts()
   {
      model.removeChildren("copy-artifacts");
      return this;
   }
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: WildFlyFeaturePackDescriptor ElementName: wildfly:file-permissions-type ElementType : file-permissions
   // MaxOccurs: -1  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>file-permissions</code> element with the given value will be created.
    * Otherwise, the existing <code>file-permissions</code> element will be returned.
    * @return  a new or existing instance of <code>FilePermissionsType<WildFlyFeaturePackDescriptor></code> 
    */
   public FilePermissionsType<WildFlyFeaturePackDescriptor> getOrCreateFilePermissions()
   {
      Node node = model.getOrCreate("file-permissions");
      FilePermissionsType<WildFlyFeaturePackDescriptor> filePermissions = new FilePermissionsTypeImpl<WildFlyFeaturePackDescriptor>(this, "file-permissions", model, node);
      return filePermissions;
   }

   /**
    * Removes the <code>file-permissions</code> element 
    * @return the current instance of <code>WildFlyFeaturePackDescriptor</code> 
    */
   public WildFlyFeaturePackDescriptor removeFilePermissions()
   {
      model.removeChildren("file-permissions");
      return this;
   }

}
