/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins;

import java.util.Collections;
import java.util.Map;
import java.util.jar.Manifest;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.ConfigurationUtils;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.MavenArchiveConfiguration;

public abstract class AbstractPackagingPluginConfiguration {
    private final MavenArchiveConfiguration archiveConfiguration;

    protected AbstractPackagingPluginConfiguration(ParsedPomFile pomFile) {
        Map rawValues = pomFile.getPluginConfiguration(this.getPluginGA());
        this.archiveConfiguration = new MavenArchiveConfiguration(pomFile, ConfigurationUtils.valueAsMap(rawValues, new ConfigurationUtils.Key("archive"), Collections.emptyMap()));
    }

    public abstract String getPluginGA();

    public abstract String[] getIncludes();

    public abstract String[] getExcludes();

    public MavenArchiveConfiguration getArchiveConfiguration() {
        return this.archiveConfiguration;
    }

    public Manifest constructManifest() {
        return this.archiveConfiguration.asManifest();
    }
}

