/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactType;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.artifact.DefaultArtifactType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenConverter {
    private static final MavenDependencyExclusion[] TYPESAFE_EXCLUSIONS_ARRAY = new MavenDependencyExclusion[0];

    private MavenConverter() {
        throw new UnsupportedOperationException("Utility class MavenConverter cannot be instantiated.");
    }

    public static MavenDependencyExclusion fromExclusion(Exclusion exclusion) {
        MavenDependencyExclusion translated = MavenDependencies.createExclusion((String)exclusion.getGroupId(), (String)exclusion.getArtifactId());
        return translated;
    }

    public static MavenDependencyExclusion fromExclusion(org.sonatype.aether.graph.Exclusion exclusion) {
        MavenDependencyExclusion translated = MavenDependencies.createExclusion((String)exclusion.getGroupId(), (String)exclusion.getArtifactId());
        return translated;
    }

    public static Set<MavenDependencyExclusion> fromExclusions(Collection<org.sonatype.aether.graph.Exclusion> exclusions) {
        LinkedHashSet<MavenDependencyExclusion> set = new LinkedHashSet<MavenDependencyExclusion>(exclusions.size());
        for (org.sonatype.aether.graph.Exclusion e : exclusions) {
            set.add(MavenConverter.fromExclusion(e));
        }
        return set;
    }

    public static String toCanonicalForm(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId()).append(":");
        sb.append(artifact.getArtifactId()).append(":");
        String extension = artifact.getExtension();
        sb.append(extension.length() == 0 ? "jar" : extension).append(":");
        String classifier = artifact.getClassifier();
        if (classifier.length() != 0) {
            sb.append(classifier).append(":");
        }
        sb.append(artifact.getVersion());
        return sb.toString();
    }

    public static MavenDependency fromDependency(org.sonatype.aether.graph.Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        MavenCoordinate coordinate = MavenCoordinates.createCoordinate((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion(), (PackagingType)PackagingType.of((String)artifact.getExtension()), (String)artifact.getClassifier());
        MavenDependency result = MavenDependencies.createDependency((MavenCoordinate)coordinate, (ScopeType)ScopeType.fromScopeType((String)dependency.getScope()), (boolean)dependency.isOptional(), (MavenDependencyExclusion[])MavenConverter.fromExclusions(dependency.getExclusions()).toArray(TYPESAFE_EXCLUSIONS_ARRAY));
        return result;
    }

    public static MavenDependency fromDependency(Dependency dependency, ArtifactTypeRegistry registry) {
        ArtifactType stereotype = registry.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        LinkedHashSet<MavenDependencyExclusion> exclusions = new LinkedHashSet<MavenDependencyExclusion>();
        for (Exclusion e : dependency.getExclusions()) {
            exclusions.add(MavenConverter.fromExclusion(e));
        }
        MavenCoordinate coordinate = MavenCoordinates.createCoordinate((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion(), (PackagingType)PackagingType.of((String)artifact.getExtension()), (String)artifact.getClassifier());
        MavenDependency result = MavenDependencies.createDependency((MavenCoordinate)coordinate, (ScopeType)ScopeType.fromScopeType((String)dependency.getScope()), (boolean)dependency.isOptional(), (MavenDependencyExclusion[])exclusions.toArray(TYPESAFE_EXCLUSIONS_ARRAY));
        return result;
    }

    public static Set<MavenDependency> fromDependencies(Collection<Dependency> dependencies, ArtifactTypeRegistry registry) {
        LinkedHashSet<MavenDependency> set = new LinkedHashSet<MavenDependency>();
        for (Dependency d : dependencies) {
            set.add(MavenConverter.fromDependency(d, registry));
        }
        return set;
    }

    public static org.sonatype.aether.graph.Dependency asDependency(MavenDependency dependency) {
        return new org.sonatype.aether.graph.Dependency(MavenConverter.asArtifact(dependency), dependency.getScope().toString(), dependency.isOptional(), MavenConverter.asExclusions(dependency.getExclusions()));
    }

    public static List<org.sonatype.aether.graph.Dependency> asDependencies(List<MavenDependency> dependencies) {
        ArrayList<org.sonatype.aether.graph.Dependency> list = new ArrayList<org.sonatype.aether.graph.Dependency>(dependencies.size());
        for (MavenDependency d : dependencies) {
            list.add(MavenConverter.asDependency(d));
        }
        return list;
    }

    public static Artifact asArtifact(MavenDependency declaration) throws CoordinateParseException {
        try {
            return new DefaultArtifact(declaration.getGroupId(), declaration.getArtifactId(), declaration.getClassifier(), declaration.getPackaging().toString(), declaration.getVersion());
        }
        catch (IllegalArgumentException e) {
            throw new CoordinateParseException("Unable to create artifact from invalid coordinates " + declaration.toCanonicalForm());
        }
    }

    public static org.sonatype.aether.graph.Exclusion asExclusion(MavenDependencyExclusion coordinates) {
        String group = coordinates.getGroupId();
        String artifact = coordinates.getArtifactId();
        group = group == null || group.length() == 0 ? "*" : group;
        artifact = artifact == null || artifact.length() == 0 ? "*" : artifact;
        return new org.sonatype.aether.graph.Exclusion(group, artifact, "*", "*");
    }

    public static List<org.sonatype.aether.graph.Exclusion> asExclusions(Collection<MavenDependencyExclusion> exclusions) {
        ArrayList<org.sonatype.aether.graph.Exclusion> list = new ArrayList<org.sonatype.aether.graph.Exclusion>(exclusions.size());
        for (MavenDependencyExclusion coords : exclusions) {
            list.add(MavenConverter.asExclusion(coords));
        }
        return list;
    }

    public static RemoteRepository asRemoteRepository(org.apache.maven.model.Repository repository) {
        return new RemoteRepository().setId(repository.getId()).setContentType(repository.getLayout()).setUrl(repository.getUrl()).setPolicy(true, MavenConverter.asRepositoryPolicy(repository.getSnapshots())).setPolicy(false, MavenConverter.asRepositoryPolicy(repository.getReleases()));
    }

    public static RemoteRepository asRemoteRepository(Repository repository) {
        return new RemoteRepository().setId(repository.getId()).setContentType(repository.getLayout()).setUrl(repository.getUrl()).setPolicy(true, MavenConverter.asRepositoryPolicy(repository.getSnapshots())).setPolicy(false, MavenConverter.asRepositoryPolicy(repository.getReleases()));
    }

    public static Proxy asProxy(org.apache.maven.settings.Proxy proxy) {
        Proxy aetherProxy = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), null);
        if (proxy.getUsername() != null || proxy.getPassword() != null) {
            aetherProxy.setAuthentication(new Authentication(proxy.getUsername(), proxy.getPassword()));
        }
        return aetherProxy;
    }

    public static org.apache.maven.model.Profile asProfile(Profile profile) {
        org.apache.maven.model.Profile mavenProfile = new org.apache.maven.model.Profile();
        if (profile != null) {
            mavenProfile.setId(profile.getId());
            mavenProfile.setActivation(MavenConverter.asActivation(profile.getActivation()));
            mavenProfile.setProperties(profile.getProperties());
            mavenProfile.setRepositories(MavenConverter.asRepositories(profile.getRepositories()));
            mavenProfile.setPluginRepositories(MavenConverter.asRepositories(profile.getPluginRepositories()));
        }
        return mavenProfile;
    }

    public static List<org.apache.maven.model.Profile> asProfiles(List<Profile> profiles) {
        ArrayList<org.apache.maven.model.Profile> mavenProfiles = new ArrayList<org.apache.maven.model.Profile>();
        for (Profile p : profiles) {
            mavenProfiles.add(MavenConverter.asProfile(p));
        }
        return mavenProfiles;
    }

    private static org.apache.maven.model.Repository asRepository(Repository repository) {
        org.apache.maven.model.Repository mavenRepository = new org.apache.maven.model.Repository();
        if (repository != null) {
            mavenRepository.setId(repository.getId());
            mavenRepository.setLayout(repository.getLayout());
            mavenRepository.setName(repository.getName());
            mavenRepository.setUrl(repository.getUrl());
            mavenRepository.setReleases(MavenConverter.asMavenRepositoryPolicy(repository.getReleases()));
            mavenRepository.setSnapshots(MavenConverter.asMavenRepositoryPolicy(repository.getSnapshots()));
        }
        return mavenRepository;
    }

    private static List<org.apache.maven.model.Repository> asRepositories(List<Repository> repositories) {
        ArrayList<org.apache.maven.model.Repository> mavenRepositories = new ArrayList<org.apache.maven.model.Repository>();
        for (Repository repository : repositories) {
            mavenRepositories.add(MavenConverter.asRepository(repository));
        }
        return mavenRepositories;
    }

    private static Activation asActivation(org.apache.maven.settings.Activation activation) {
        Activation mavenActivation = new Activation();
        if (activation != null) {
            mavenActivation.setActiveByDefault(activation.isActiveByDefault());
            mavenActivation.setJdk(activation.getJdk());
            if (activation.getFile() != null) {
                mavenActivation.setFile(MavenConverter.asActivationFile(activation.getFile()));
            }
            if (activation.getOs() != null) {
                mavenActivation.setOs(MavenConverter.asActivationOS(activation.getOs()));
            }
            if (activation.getProperty() != null) {
                mavenActivation.setProperty(MavenConverter.asActivationProperty(activation.getProperty()));
            }
        }
        return mavenActivation;
    }

    private static org.apache.maven.model.ActivationFile asActivationFile(ActivationFile file) {
        org.apache.maven.model.ActivationFile mavenActivationFile = new org.apache.maven.model.ActivationFile();
        if (file != null) {
            mavenActivationFile.setExists(file.getExists());
            mavenActivationFile.setMissing(file.getMissing());
        }
        return mavenActivationFile;
    }

    private static ActivationOS asActivationOS(org.apache.maven.settings.ActivationOS os) {
        ActivationOS mavenOS = new ActivationOS();
        if (os != null) {
            mavenOS.setArch(os.getArch());
            mavenOS.setFamily(os.getFamily());
            mavenOS.setName(os.getName());
            mavenOS.setVersion(os.getVersion());
        }
        return mavenOS;
    }

    private static ActivationProperty asActivationProperty(org.apache.maven.settings.ActivationProperty property) {
        ActivationProperty mavenProperty = new ActivationProperty();
        if (property != null) {
            mavenProperty.setName(property.getName());
            mavenProperty.setValue(property.getValue());
        }
        return mavenProperty;
    }

    private static org.sonatype.aether.repository.RepositoryPolicy asRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new org.sonatype.aether.repository.RepositoryPolicy(enabled, updates, checksums);
    }

    private static org.sonatype.aether.repository.RepositoryPolicy asRepositoryPolicy(org.apache.maven.settings.RepositoryPolicy policy) {
        boolean enabled = true;
        String checksums = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksums = policy.getChecksumPolicy();
            }
        }
        return new org.sonatype.aether.repository.RepositoryPolicy(enabled, updates, checksums);
    }

    private static RepositoryPolicy asMavenRepositoryPolicy(org.apache.maven.settings.RepositoryPolicy policy) {
        RepositoryPolicy mavenPolicy = new RepositoryPolicy();
        if (policy != null) {
            mavenPolicy.setChecksumPolicy(policy.getChecksumPolicy());
            mavenPolicy.setUpdatePolicy(policy.getUpdatePolicy());
            mavenPolicy.setEnabled(policy.isEnabled());
        }
        return mavenPolicy;
    }
}

