/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.htmlunit;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import org.jboss.test.faces.ApplicationServer;
import org.jboss.test.faces.FacesEnvironment;
import org.jboss.test.faces.htmlunit.LocalWebClient;
import org.jboss.test.faces.staging.StagingServer;

public class HtmlUnitEnvironment
extends FacesEnvironment {
    private WebClient webClient;

    public HtmlUnitEnvironment() {
    }

    public HtmlUnitEnvironment(ApplicationServer applicationServer) {
        super(applicationServer);
    }

    private WebClient createWebClient() {
        ApplicationServer server = this.getServer();
        WebClient result = server instanceof StagingServer ? new LocalWebClient((StagingServer)server) : new WebClient();
        return result;
    }

    public WebClient getWebClient() {
        return this.webClient;
    }

    public FacesEnvironment start() {
        super.start();
        this.webClient = this.createWebClient();
        return this;
    }

    public <P extends Page> P getPage(String url) throws FailingHttpStatusCodeException, MalformedURLException, IOException {
        String hostAddress = MessageFormat.format("http://localhost:{0,number,#####}", this.getServer().getPort());
        Page page = this.webClient.getPage(hostAddress + url);
        return (P)page;
    }

    public void release() {
        this.webClient.closeAllWindows();
        this.webClient = null;
        super.release();
    }
}

