/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.mock;

import java.util.HashMap;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.facelets.TagHandlerDelegateFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.easymock.IMocksControl;
import org.easymock.classextension.EasyMock;
import org.jboss.test.faces.mock.FacesMock;
import org.jboss.test.faces.mock.MockFacesContext;
import org.jboss.test.faces.mock.factory.FactoryMock;
import org.jboss.test.faces.mock.factory.FactoryMockingService;
import org.jboss.test.faces.writer.RecordingResponseWriter;

public class MockFacesEnvironment {
    private static ThreadLocal<MockFacesEnvironment> instance = new ThreadLocal();
    private final IMocksControl mocksControl;
    private FacesContext facesContext;
    private boolean withFactories = false;
    private ExternalContext externalContext;
    private ELContext elContext;
    private ServletContext context;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Application application;
    private ViewHandler viewHandler;
    private RenderKit renderKit;
    private ResponseStateManager responseStateManager;
    private String name;
    private RecordingResponseWriter responseWriter;
    private static boolean jsf2;
    private FactoryMockingService service = FactoryMockingService.getInstance();

    public static MockFacesEnvironment createEnvironment() {
        return new MockFacesEnvironment((IMocksControl)EasyMock.createControl());
    }

    public static MockFacesEnvironment createStrictEnvironment() {
        return new MockFacesEnvironment((IMocksControl)EasyMock.createStrictControl());
    }

    public static MockFacesEnvironment createNiceEnvironment() {
        return new MockFacesEnvironment((IMocksControl)EasyMock.createNiceControl());
    }

    public static MockFacesEnvironment getInstance() {
        return instance.get();
    }

    public MockFacesEnvironment(IMocksControl mocksControl, String name) {
        this(mocksControl);
        this.name = name;
    }

    MockFacesEnvironment(IMocksControl mocksControl) {
        this.mocksControl = mocksControl;
        Class facesContextClass = FacesContext.class;
        try {
            facesContextClass = Class.forName("com.sun.faces.config.InitFacesContext");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.facesContext = this.createMock(facesContextClass);
        instance.set(this);
    }

    public <T> T createMock(Class<T> mock) {
        return this.createMock(this.name, mock);
    }

    public <T> T createMock(String name, Class<T> mock) {
        return FacesMock.createMock(name, mock, this.mocksControl);
    }

    public MockFacesEnvironment withExternalContext() {
        this.externalContext = this.createMock(ExternalContext.class);
        this.recordExternalContext();
        return this;
    }

    private void recordExternalContext() {
        org.easymock.EasyMock.expect((Object)this.facesContext.getExternalContext()).andStubReturn((Object)this.externalContext);
        org.easymock.EasyMock.expect((Object)this.externalContext.getContext()).andStubReturn(null);
        org.easymock.EasyMock.expect((Object)this.externalContext.getApplicationMap()).andStubReturn(new HashMap());
    }

    public MockFacesEnvironment withELContext() {
        this.elContext = this.createMock(ELContext.class);
        this.recordELContext();
        return this;
    }

    private void recordELContext() {
        org.easymock.EasyMock.expect((Object)this.facesContext.getELContext()).andStubReturn((Object)this.elContext);
    }

    public MockFacesEnvironment withServletRequest() {
        if (null == this.externalContext) {
            this.withExternalContext();
        }
        this.context = (ServletContext)this.mocksControl.createMock(ServletContext.class);
        this.request = (HttpServletRequest)this.mocksControl.createMock(HttpServletRequest.class);
        this.response = (HttpServletResponse)this.mocksControl.createMock(HttpServletResponse.class);
        this.recordServletRequest();
        return this;
    }

    private void recordServletRequest() {
        org.easymock.EasyMock.expect((Object)this.externalContext.getContext()).andStubReturn((Object)this.context);
        org.easymock.EasyMock.expect((Object)this.externalContext.getRequest()).andStubReturn((Object)this.request);
        org.easymock.EasyMock.expect((Object)this.externalContext.getResponse()).andStubReturn((Object)this.response);
    }

    public MockFacesEnvironment withFactories() {
        FactoryFinder.releaseFactories();
        this.setupAndEnhance(ApplicationFactory.class);
        this.setupAndEnhance(FacesContextFactory.class);
        this.setupAndEnhance(RenderKitFactory.class);
        this.setupAndEnhance(LifecycleFactory.class);
        if (jsf2) {
            this.setupAndEnhance(TagHandlerDelegateFactory.class);
            this.setupAndEnhance(ExceptionHandlerFactory.class);
            this.setupAndEnhance(PartialViewContextFactory.class);
            this.setupAndEnhance(ExternalContextFactory.class);
        }
        this.withFactories = true;
        return this;
    }

    private <T> T setupAndEnhance(Class<T> type) {
        String factoryName = type.getName();
        FactoryMock<T> factoryMock = this.service.createFactoryMock(type);
        FactoryFinder.setFactory((String)factoryName, (String)factoryMock.getMockClassName());
        T mock = type.cast(FactoryFinder.getFactory((String)factoryName));
        this.service.enhance(factoryMock, mock);
        return mock;
    }

    public MockFacesEnvironment withApplication() {
        this.application = this.createMock(Application.class);
        this.viewHandler = this.createMock(ViewHandler.class);
        this.recordApplication();
        return this;
    }

    private void recordApplication() {
        org.easymock.EasyMock.expect((Object)this.facesContext.getApplication()).andStubReturn((Object)this.application);
        org.easymock.EasyMock.expect((Object)this.application.getViewHandler()).andStubReturn((Object)this.viewHandler);
    }

    public MockFacesEnvironment withRenderKit() {
        this.renderKit = this.createMock(RenderKit.class);
        this.responseStateManager = this.createMock(ResponseStateManager.class);
        this.recordRenderKit();
        return this;
    }

    private void recordRenderKit() {
        org.easymock.EasyMock.expect((Object)this.facesContext.getRenderKit()).andStubReturn((Object)this.renderKit);
        org.easymock.EasyMock.expect((Object)this.renderKit.getResponseStateManager()).andStubReturn((Object)this.responseStateManager);
    }

    public MockFacesEnvironment withReSponseWriter() {
        this.responseWriter = new RecordingResponseWriter("UTF-8", "text/html");
        this.recordResponseWrrier();
        return this;
    }

    private void recordResponseWrrier() {
        org.easymock.EasyMock.expect((Object)this.facesContext.getResponseWriter()).andStubReturn((Object)this.responseWriter);
    }

    public MockFacesEnvironment replay() {
        this.mocksControl.replay();
        MockFacesContext.setCurrentInstance(this.facesContext);
        return this;
    }

    public MockFacesEnvironment reset() {
        this.mocksControl.reset();
        this.recordEnvironment();
        return this;
    }

    private void recordEnvironment() {
        if (null != this.externalContext) {
            this.recordExternalContext();
        }
        if (null != this.elContext) {
            this.recordELContext();
        }
        if (null != this.request) {
            this.recordServletRequest();
        }
        if (null != this.application) {
            this.recordApplication();
        }
        if (null != this.renderKit) {
            this.recordRenderKit();
        }
        if (null != this.responseWriter) {
            this.recordResponseWrrier();
        }
        if (this.withFactories) {
            FactoryFinder.releaseFactories();
            this.withFactories();
        }
    }

    public MockFacesEnvironment resetToStrict() {
        this.mocksControl.resetToStrict();
        this.recordEnvironment();
        return this;
    }

    public MockFacesEnvironment resetToDefault() {
        this.mocksControl.resetToDefault();
        this.recordEnvironment();
        return this;
    }

    public MockFacesEnvironment resetToNice() {
        this.mocksControl.resetToNice();
        this.recordEnvironment();
        return this;
    }

    public void verify() {
        this.mocksControl.verify();
    }

    public void release() {
        MockFacesContext.setCurrentInstance(null);
        instance.remove();
        if (this.withFactories) {
            FactoryFinder.releaseFactories();
        }
    }

    public FacesContext getFacesContext() {
        return this.facesContext;
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public ELContext getElContext() {
        return this.elContext;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public Application getApplication() {
        return this.application;
    }

    public ViewHandler getViewHandler() {
        return this.viewHandler;
    }

    public RenderKit getRenderKit() {
        return this.renderKit;
    }

    public ResponseStateManager getResponseStateManager() {
        return this.responseStateManager;
    }

    public RecordingResponseWriter getResponseWriter() {
        return this.responseWriter;
    }

    public IMocksControl getControl() {
        return this.mocksControl;
    }

    static {
        try {
            Class.forName("javax.faces.component.behavior.Behavior", false, FacesContext.class.getClassLoader());
            jsf2 = true;
        }
        catch (Throwable e) {
            jsf2 = false;
        }
    }
}

