/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jboss.logging.Logger;
import org.jboss.util.UnexpectedThrowable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestCase
extends TestCase {
    private static final Logger staticLog = Logger.getLogger(AbstractTestCase.class);
    long startTime;

    public AbstractTestCase(String name) {
        super(name);
    }

    public abstract Logger getLog();

    public URL getResource(String name) {
        return AbstractTestCase.findResource(((Object)((Object)this)).getClass(), name);
    }

    public static URL findResource(final Class clazz, final String name) {
        PrivilegedAction<URL> action = new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return clazz.getResource(name);
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected void setUp() throws Exception {
        this.log("Starting");
        this.startTime = System.currentTimeMillis();
    }

    protected void tearDown() throws Exception {
        this.getLog().debug((Object)(this.getName() + " took " + (System.currentTimeMillis() - this.startTime) + "ms"));
        this.log("Stopping");
    }

    protected void configureLogging() {
    }

    protected abstract void enableTrace(String var1);

    protected void assertEquals(float one, float two) {
        AbstractTestCase.assertEquals((float)one, (float)two, (float)0.0f);
    }

    protected void assertEquals(double one, double two) {
        AbstractTestCase.assertEquals((double)one, (double)two, (double)0.0);
    }

    protected void assertEquals(Object[] expected, Object[] actual) {
        if (!Arrays.equals(expected, actual)) {
            String expectedString = null;
            if (expected != null) {
                expectedString = Arrays.asList(expected).toString();
            }
            String actualString = null;
            if (actual != null) {
                actualString = Arrays.asList(actual).toString();
            }
            throw new AssertionFailedError("expected: " + expectedString + " actual: " + actualString);
        }
    }

    protected void assertEquals(String context, Object[] expected, Object[] actual) {
        if (!Arrays.equals(expected, actual)) {
            String expectedString = null;
            if (expected != null) {
                expectedString = Arrays.asList(expected).toString();
            }
            String actualString = null;
            if (actual != null) {
                actualString = Arrays.asList(actual).toString();
            }
            throw new AssertionFailedError(context + " expected: " + expectedString + " actual: " + actualString);
        }
    }

    protected void assertEmpty(Collection c) {
        AbstractTestCase.assertNotNull((Object)c);
        if (!c.isEmpty()) {
            throw new AssertionFailedError("Expected empty collection " + c);
        }
    }

    protected void assertEmpty(String context, Collection c) {
        AbstractTestCase.assertNotNull((Object)c);
        if (!c.isEmpty()) {
            throw new AssertionFailedError(context);
        }
    }

    protected static void assertEmpty(Object[] array) {
        if (array != null) {
            AbstractTestCase.assertEquals((String)Arrays.asList(array).toString(), (int)0, (int)array.length);
        }
    }

    public static void checkThrowable(Class<? extends Throwable> expected, Throwable throwable) {
        if (expected == null) {
            AbstractTestCase.fail((String)"Must provide an expected class");
        }
        if (throwable == null) {
            AbstractTestCase.fail((String)"Must provide a throwable for comparison");
        }
        if (throwable instanceof AssertionFailedError || throwable instanceof AssertionError) {
            throw (Error)throwable;
        }
        if (!expected.equals(throwable.getClass())) {
            staticLog.error((Object)"Unexpected throwable", throwable);
            AbstractTestCase.fail((String)("Unexpected throwable: " + throwable));
        } else {
            staticLog.debug((Object)("Got expected " + expected.getName() + "(" + throwable + ")"));
        }
    }

    public static void checkThrowableRethrow(Class<? extends Throwable> expected, Throwable throwable) throws Exception {
        AbstractTestCase.assertNotNull(expected);
        AbstractTestCase.assertNotNull((Object)throwable);
        if (!expected.equals(throwable.getClass())) {
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new UnexpectedThrowable("UnexpectedThrowable", throwable);
        }
        staticLog.debug((Object)("Got expected " + expected.getName() + "(" + throwable + ")"));
    }

    public static void checkDeepThrowable(Class<? extends Throwable> expected, Throwable throwable) {
        AbstractTestCase.assertNotNull(expected);
        AbstractTestCase.assertNotNull((Object)throwable);
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof AssertionFailedError || throwable instanceof AssertionError) {
            throw (Error)throwable;
        }
        if (!expected.equals(throwable.getClass())) {
            staticLog.error((Object)"Unexpected throwable", throwable);
            AbstractTestCase.fail((String)("Unexpected throwable: " + throwable));
        } else {
            staticLog.debug((Object)("Got expected " + expected.getName() + "(" + throwable + ")"));
        }
    }

    public static void checkDeepThrowableRethrow(Class<? extends Throwable> expected, Throwable throwable) throws Exception {
        AbstractTestCase.assertNotNull(expected);
        AbstractTestCase.assertNotNull((Object)throwable);
        Throwable original = throwable;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (!expected.equals(throwable.getClass())) {
            if (original instanceof Exception) {
                throw (Exception)original;
            }
            if (original instanceof Error) {
                throw (Error)original;
            }
            throw new UnexpectedThrowable("UnexpectedThrowable", original);
        }
        staticLog.debug((Object)("Got expected " + expected.getName() + "(" + throwable + ")"));
    }

    protected byte[] serialize(Serializable object) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.close();
        return baos.toByteArray();
    }

    protected Object deserialize(byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    protected <T> T serializeDeserialize(Serializable value, Class<T> expected) throws Exception {
        byte[] bytes = this.serialize(value);
        Object result = this.deserialize(bytes);
        return this.assertInstanceOf(result, expected);
    }

    protected <T> T assertInstanceOf(Object o, Class<T> expectedType) {
        return this.assertInstanceOf(o, expectedType, true);
    }

    protected <T> T assertInstanceOf(Object o, Class<T> expectedType, boolean allowNull) {
        if (expectedType == null) {
            AbstractTestCase.fail((String)"Null expectedType");
        }
        if (o == null) {
            if (!allowNull) {
                AbstractTestCase.fail((String)"Null object not allowed.");
            } else {
                return null;
            }
        }
        try {
            return expectedType.cast(o);
        }
        catch (ClassCastException e) {
            AbstractTestCase.fail((String)("Object " + o + " of class " + o.getClass().getName() + " is not an instanceof " + expectedType.getName()));
            return null;
        }
    }

    protected void failure(String reason, Throwable cause) {
        this.getLog().error((Object)reason, cause);
        if (cause instanceof AssertionFailedError) {
            throw (AssertionFailedError)cause;
        }
        AssertionFailedError error = new AssertionFailedError(reason);
        error.initCause(cause);
        throw error;
    }

    private void log(String context) {
        this.getLog().debug((Object)("==== " + context + " " + this.getName() + " ===="));
    }
}

