/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test;

import javax.management.MBeanServerConnection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.test.AbstractTestDelegate;
import org.jboss.test.JBossTestCase;
import org.jboss.test.JBossTestClusteredServices;
import org.jboss.test.JBossTestClusteredSetup;

public class JBossClusteredTestCase
extends JBossTestCase {
    JBossTestClusteredServices clusterServices;

    public static AbstractTestDelegate getDelegate(Class clazz) throws Exception {
        JBossTestClusteredServices delegate = new JBossTestClusteredServices(clazz);
        return delegate;
    }

    public JBossClusteredTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.clusterServices = (JBossTestClusteredServices)this.delegate;
    }

    public void testServerFound() throws Exception {
        if (deploymentException != null) {
            throw deploymentException;
        }
        JBossClusteredTestCase.assertTrue((String)"Server was not found", (this.getServers() != null ? 1 : 0) != 0);
    }

    public MBeanServerConnection[] getAdaptors() throws Exception {
        return this.clusterServices.getAdaptors();
    }

    public String[] getServers() throws Exception {
        return this.clusterServices.getServers();
    }

    public String[] getNamingURLs() throws Exception {
        return this.clusterServices.getNamingURLs();
    }

    public String[] getHANamingURLs() throws Exception {
        return this.clusterServices.getHANamingURLs();
    }

    public String[] getHttpURLs() throws Exception {
        return this.clusterServices.getHttpURLs();
    }

    protected void deploy(MBeanServerConnection server, String name) throws Exception {
        this.clusterServices.deploy(server, name);
    }

    protected void redeploy(MBeanServerConnection server, String name) throws Exception {
        this.clusterServices.redeploy(server, name);
    }

    protected void undeploy(MBeanServerConnection server, String name) throws Exception {
        this.clusterServices.undeploy(server, name);
    }

    public static Test getDeploySetup(Test test, String jarNames) throws Exception {
        return new JBossTestClusteredSetup(test, jarNames);
    }

    public static Test getDeploySetup(Class clazz, String jarNames) throws Exception {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestSuite(clazz));
        return JBossClusteredTestCase.getDeploySetup((Test)suite, jarNames);
    }

    public void setServerNames(String[] snames) throws Exception {
        ((JBossTestClusteredServices)this.delegate).setServerNames(snames);
    }
}

