/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.browser;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jboss.test.selenium.browser.BrowserMode;
import org.jboss.test.selenium.browser.BrowserType;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;

public class Browser {
    private static final int GROUP_EXECUTABLE = 2;
    private static final int GROUP_MODE = 1;
    BrowserMode browserMode;
    File executable;
    Pattern pattern = Pattern.compile("^\\*([^\\s]+)(?:$|\\s+(.*))$");

    public Browser(String stringRepresentation) {
        Matcher matcher = this.pattern.matcher(stringRepresentation);
        if (!matcher.find()) {
            throw new IllegalArgumentException(SimplifiedFormat.format("given browser's stringRepresentation '{0}' doesn't match pattern", stringRepresentation));
        }
        this.browserMode = BrowserMode.parseMode(matcher.group(1));
        if (matcher.group(2) != null) {
            this.executable = new File(matcher.group(2));
        }
    }

    public Browser(BrowserMode browserMode) {
        this.browserMode = browserMode;
    }

    public Browser(BrowserMode browserMode, File executableFile) {
        this.browserMode = browserMode;
        this.executable = executableFile;
    }

    public BrowserMode getMode() {
        return this.browserMode;
    }

    public BrowserType getType() {
        return this.browserMode.getBrowserType();
    }

    public String getAsString() {
        StringBuilder builder = new StringBuilder(this.browserMode.getMode());
        if (this.executable != null) {
            builder.append(" ").append(this.executable.toString());
        }
        return builder.toString();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("mode", (Object)this.browserMode).append("type", (Object)this.browserMode.getBrowserType()).append("executable", (Object)this.executable).toString();
    }
}

