/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.report.impl.junit;

import java.io.IOException;
import java.io.StringWriter;
import org.jboss.unit.report.impl.junit.JUnitTestReport;
import org.jboss.unit.runner.TestRunnerEvent;
import org.jboss.unit.runner.TestRunnerEventListener;
import org.jboss.unit.runner.event.EndRunnerEvent;
import org.jboss.unit.runner.event.EndTestCaseEvent;
import org.jboss.unit.runner.event.EndTestSuiteEvent;
import org.jboss.unit.runner.event.RunnerFailureEvent;
import org.jboss.unit.runner.event.StartRunnerEvent;
import org.jboss.unit.runner.event.StartTestCaseEvent;
import org.jboss.unit.runner.event.StartTestSuiteEvent;
import org.jboss.unit.tooling.SystemOutputManager;
import org.jboss.unit.tooling.SystemOutputView;

public class JUnitReporter
implements TestRunnerEventListener {
    private JUnitTestReport report;
    private String toDir;
    private SystemOutputView view;

    public JUnitReporter(String reportToDir) {
        this.toDir = reportToDir;
        this.report = new JUnitTestReport();
    }

    public JUnitReporter(String reportToDir, String testSuiteName) {
        this(reportToDir);
        this.report.setTestSuiteName(testSuiteName);
    }

    public void onEvent(TestRunnerEvent event) {
        if (event instanceof StartRunnerEvent) {
            this.report.startJUnitTestSuite((StartRunnerEvent)event);
            this.view = SystemOutputManager.getInstance().createView(false);
        } else if (event instanceof EndRunnerEvent) {
            try {
                StringWriter out = new StringWriter();
                StringWriter err = new StringWriter();
                this.view.writeTo(out, err);
                this.report.appendSystemError(err.toString());
                this.report.appendSystemOutput(out.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.report.endTestSuite((EndRunnerEvent)event);
            this.report.exportXML(this.toDir);
        } else if (event instanceof RunnerFailureEvent) {
            this.report.runnerFailed((RunnerFailureEvent)event);
        } else if (event instanceof StartTestSuiteEvent) {
            this.report.addTestedSuiteName(((StartTestSuiteEvent)event).getTestInfo().getName());
        } else if (event instanceof EndTestSuiteEvent) {
            this.report.removeLastTestedSuite();
        } else if (event instanceof StartTestCaseEvent) {
            this.report.startTest((StartTestCaseEvent)event);
        } else if (event instanceof EndTestCaseEvent) {
            this.report.endTest((EndTestCaseEvent)event);
        }
    }
}

