/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.report.impl.junit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.unit.Failure;
import org.jboss.unit.FailureType;
import org.jboss.unit.TestId;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.runner.TestResult;
import org.jboss.unit.runner.event.EndRunnerEvent;
import org.jboss.unit.runner.event.EndTestCaseEvent;
import org.jboss.unit.runner.event.RunnerFailureEvent;
import org.jboss.unit.runner.event.StartRunnerEvent;
import org.jboss.unit.runner.event.StartTestCaseEvent;
import org.jboss.unit.runner.results.TestFailure;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JUnitTestReport {
    private String testSuiteName;
    public static final String DEFAULT_TEST_SUITE_NAME = "JBossUnitTestSuite";
    public static final String TEST_FILE_NAME_START = "TEST-";
    private Document document;
    protected Element rootElement;
    private Map<TestId, TestInfo> startedTests = new HashMap<TestId, TestInfo>();
    private StringBuffer systemErr = new StringBuffer();
    private StringBuffer systemOut = new StringBuffer();
    private int tests;
    private int errors;
    private int failed;
    private String timeStamp;
    private LinkedList<String> testSuiteNames = new LinkedList();
    private NumberFormat FORMAT = NumberFormat.getInstance();

    public JUnitTestReport() {
    }

    public JUnitTestReport(String testSuiteName) {
        this.testSuiteName = testSuiteName;
    }

    public void startJUnitTestSuite(StartRunnerEvent event) {
        this.document = JUnitTestReport.getDocumentBuilder().newDocument();
        this.rootElement = this.document.createElement("testsuite");
        this.rootElement.setAttribute("timestamp", this.getTimestamp());
        this.rootElement.setAttribute("hostname", JUnitTestReport.getHostName());
        this.rootElement.setAttribute("name", this.testSuiteName);
        Element properties = this.document.createElement("properties");
        this.rootElement.appendChild(properties);
    }

    public void addTestedSuiteName(String testedClassName) {
        this.testSuiteNames.add(testedClassName);
    }

    public void removeLastTestedSuite() {
        this.testSuiteNames.removeLast();
    }

    public void startTest(StartTestCaseEvent event) {
        this.startedTests.put(event.getTestId(), event.getTestInfo());
        ++this.tests;
    }

    public void runnerFailed(RunnerFailureEvent event) {
        ++this.tests;
        ++this.errors;
        StringBuffer nb = new StringBuffer();
        Element e = this.document.createElement("error");
        e.setAttribute("type", event.getFailure().getType().name());
        e.setAttribute("message", event.getFailure().getMessage());
        e.appendChild(this.document.createCDATASection(JUnitTestReport.stackToString(event.getFailure().getStackTrace())));
        this.rootElement.appendChild(e);
    }

    public void endTest(EndTestCaseEvent event) {
        TestId testId = event.getTestId();
        TestResult result = event.getTestResult();
        Element test = this.document.createElement("testcase");
        TestInfo info = this.startedTests.get(testId);
        StringBuffer nb = new StringBuffer();
        for (String testSuiteName : this.testSuiteNames) {
            nb.append(testSuiteName);
            nb.append(".");
        }
        nb.append(info.getName());
        String testName = nb.toString();
        StringBuffer parameters = new StringBuffer();
        Iterator<String> i = result.getParametrization().keySet().iterator();
        while (i.hasNext()) {
            String name = i.next();
            String value = result.getParametrization().get(name);
            parameters.append(name + "=" + value);
            if (!i.hasNext()) continue;
            parameters.append("&");
        }
        if (parameters.length() > 0) {
            testName = testName + "?" + parameters.toString();
        }
        test.setAttribute("name", testName);
        test.setAttribute("time", this.FORMAT.format((double)result.getDurationMillis() / 1000.0));
        if (info != null) {
            this.startedTests.remove(testId);
        } else {
            Element errorNotStarted = this.document.createElement("error");
            errorNotStarted.setAttribute("message", "TestCase: " + testName + " was not started properly. (No StartTestEvent)");
            test.appendChild(errorNotStarted);
        }
        if (result instanceof TestFailure) {
            String failureType;
            TestFailure testFailure = (TestFailure)result;
            Failure failure = testFailure.getFailure();
            if (FailureType.ASSERTION == failure.getType()) {
                ++this.failed;
                failureType = "failure";
            } else {
                ++this.errors;
                failureType = "error";
            }
            test.appendChild(this.addError(failureType, failure.getStackTrace()));
        }
        this.rootElement.appendChild(test);
    }

    public void endTestSuite(EndRunnerEvent event) {
        if (this.startedTests.size() > 0) {
            for (TestId id : this.startedTests.keySet()) {
                Element errorNotEnded = this.document.createElement("error");
                errorNotEnded.setAttribute("message", "Testcase: " + id + " was not ended properly. (No EndTestEvent)");
                this.rootElement.appendChild(errorNotEnded);
            }
        }
        this.rootElement.setAttribute("tests", Integer.toString(this.tests));
        this.rootElement.setAttribute("errors", Integer.toString(this.errors));
        this.rootElement.setAttribute("failures", Integer.toString(this.failed));
        Element systemError = this.document.createElement("system-err");
        systemError.appendChild(this.document.createCDATASection(this.systemErr.toString()));
        Element systemOutElement = this.document.createElement("system-out");
        systemOutElement.appendChild(this.document.createCDATASection(this.systemOut.toString()));
        this.rootElement.appendChild(systemError);
        this.rootElement.appendChild(systemOutElement);
    }

    public void appendSystemOutput(String output) {
        this.systemOut.append(output);
    }

    public void appendSystemError(String error) {
        this.systemErr.append(error);
    }

    public void exportXML(String toDir) {
        try {
            toDir = this.checkDir(toDir);
            StringBuffer filePath = new StringBuffer();
            filePath.append(toDir).append(File.separator).append(TEST_FILE_NAME_START).append(this.getTestSuiteName()).append(this.getTestSuiteName().equals(DEFAULT_TEST_SUITE_NAME) ? "-" + this.getTimestamp() : "").append(".xml");
            File file = new File(filePath.toString());
            DOMSource source = new DOMSource(this.rootElement);
            Transformer xtrans = TransformerFactory.newInstance().newTransformer();
            xtrans.setOutputProperty("indent", "yes");
            xtrans.setOutputProperty("method", "xml");
            xtrans.setOutputProperty("standalone", "yes");
            StreamResult result = new StreamResult(new FileOutputStream(file));
            xtrans.transform(source, result);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    private String checkDir(String toDir) {
        File dir = new File(toDir);
        if (!dir.exists()) {
            dir.mkdir();
        }
        return dir.toString();
    }

    private Element addError(String type, Throwable t) {
        Element error = this.document.createElement(type);
        error.setAttribute("message", t.getMessage());
        error.setAttribute("type", t.getClass().getName());
        error.appendChild(this.document.createCDATASection(JUnitTestReport.stackToString(t)));
        return error;
    }

    private static String stackToString(Throwable t) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        t.printStackTrace(printWriter);
        printWriter.flush();
        printWriter.close();
        return ((Object)writer).toString();
    }

    private String getTimestamp() {
        if (this.timeStamp == null) {
            SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.timeStamp = date.format(new Date());
        }
        return this.timeStamp;
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getTestSuiteName() {
        if (this.testSuiteName == null) {
            return DEFAULT_TEST_SUITE_NAME;
        }
        return this.testSuiteName;
    }

    public void setTestSuiteName(String testSuiteName) {
        this.testSuiteName = testSuiteName;
    }
}

