/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.runner.impl.pojo;

import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.unit.Failure;
import org.jboss.unit.TestId;
import org.jboss.unit.driver.impl.pojo.POJOTestSuiteDriver;
import org.jboss.unit.info.TestSuiteInfo;
import org.jboss.unit.runner.AbstractTestRunner;
import org.jboss.unit.runner.ParametrizationSet;
import org.jboss.unit.runner.TestRunnerContext;
import org.jboss.unit.runner.event.RunnerFailureEvent;
import org.jboss.unit.runner.impl.DelegateRunnerEventFilter;
import org.jboss.unit.runner.impl.TestRunnerContextSupport;
import org.jboss.unit.runner.impl.driver.TestDriverRunner;
import org.jboss.unit.runner.model.pojo.POJOTestSuiteDef;
import org.jboss.unit.runner.model.pojo.TestCaseDef;
import org.jboss.unit.runner.model.pojo.TestClassDef;

public class POJOTestRunner
extends AbstractTestRunner {
    private final POJOTestSuiteDef def;

    public POJOTestRunner(POJOTestSuiteDef suiteDef) {
        this.def = suiteDef;
    }

    protected void internalRun(TestRunnerContext context) {
        for (TestClassDef testClass : this.def.getTestClasses()) {
            String className = testClass.getName();
            DelegateRunnerEventFilter filter = new DelegateRunnerEventFilter(context.getEventListener());
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                POJOTestSuiteDriver driver = new POJOTestSuiteDriver(clazz);
                TestSuiteInfo testSuiteInfo = (TestSuiteInfo)driver.getInfo();
                ArrayList<String> testCaseNames = new ArrayList<String>();
                for (TestCaseDef testCase : testClass.getTestCases()) {
                    testCaseNames.add(testCase.getName());
                }
                if (testCaseNames.size() == 0) {
                    testCaseNames.addAll(testSuiteInfo.getNames());
                }
                ParametrizationSet parametrizations = this.def.getParameters().getParametrization().clone();
                parametrizations.combine(testClass.getParameters().getParametrization());
                parametrizations.combine(context.getParametrizations());
                HashMap<String, String> properties = new HashMap<String, String>(testClass.getProperties());
                properties.putAll(context.getProperties());
                TestRunnerContextSupport pojoContext = new TestRunnerContextSupport(properties, parametrizations, context.getFilter(), filter);
                TestDriverRunner runner = new TestDriverRunner(driver);
                for (String testCaseName : testCaseNames) {
                    TestId testCaseId = new TestId(testCaseName);
                    runner.setTestId(testCaseId);
                    runner.run(pojoContext);
                }
            }
            catch (Exception e) {
                context.getEventListener().onEvent(new RunnerFailureEvent(Failure.createFailure("Cannot execute test class " + className, e)));
            }
        }
    }
}

