/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.tooling.filter;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.unit.TestId;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.runner.TestFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InfoTestFilter
implements TestFilter {
    private Set<String> keywords = new HashSet<String>();
    private Set<String> names = new HashSet<String>();
    private Set<String> namePatterns = new HashSet<String>();

    public InfoTestFilter() {
    }

    public InfoTestFilter(Set<String> keywords, Set<String> names, Set<String> namePatterns) {
        if (keywords == null) {
            throw new IllegalArgumentException("keywords cannot be null");
        }
        if (names == null) {
            throw new IllegalArgumentException("names cannot be null");
        }
        if (namePatterns == null) {
            throw new IllegalArgumentException("namePatterns cannot be null");
        }
        this.keywords = keywords;
        this.names = names;
        this.namePatterns = namePatterns;
    }

    public InfoTestFilter addKeyword(String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException("keyword cannot be null");
        }
        this.keywords.add(keyword);
        return this;
    }

    public InfoTestFilter addUnparsedKeywords(String keywordsString) {
        String[] keywordValues;
        if (keywordsString == null) {
            throw new IllegalArgumentException("keywordsString cannot be null");
        }
        for (String keyword : keywordValues = keywordsString.split(",")) {
            this.keywords.add(keyword.trim());
        }
        return this;
    }

    public InfoTestFilter addName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.names.add(name);
        return this;
    }

    public InfoTestFilter addUnparsedNames(String namesString) {
        String[] namesValues;
        if (namesString == null) {
            throw new IllegalArgumentException("namesString cannot be null");
        }
        for (String name : namesValues = namesString.split(",")) {
            this.names.add(name.trim());
        }
        return this;
    }

    public InfoTestFilter addNamePattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cannot be null");
        }
        this.namePatterns.add(pattern);
        return this;
    }

    public InfoTestFilter addUnparsedNamePatterns(String patternString) {
        String[] patternValues;
        if (patternString == null) {
            throw new IllegalArgumentException("patternString cannot be null");
        }
        for (String pattern : patternValues = patternString.split(",")) {
            this.namePatterns.add(pattern.trim());
        }
        return this;
    }

    @Override
    public abstract boolean include(TestId var1, TestInfo var2);

    @Override
    public boolean include(TestId testId, Map<String, String> parametrization, TestInfo testInfo) {
        return this.include(testId, testInfo);
    }

    boolean checkName(String name) {
        for (String s : this.names) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    boolean checkKeywords(Set<String> keywords) {
        for (String keyword : this.keywords) {
            for (String toMatch : keywords) {
                if (!keyword.equals(toMatch)) continue;
                return true;
            }
        }
        return false;
    }

    boolean checkNamePatterns(String name) {
        for (String regex : this.namePatterns) {
            if (!name.matches(regex)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Filter: ").append(this.getClass().getName()).append("; names: ").append(this.names.toString()).append("; keywords: ").append(this.keywords.toString()).append("; namePatterns: ").append(this.namePatterns.toString()).append(";");
        return sb.toString();
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public Set<String> getNamePatterns() {
        return this.namePatterns;
    }
}

