/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionTools {
    public static <U> Iterable<U> iterable(final Iterator<U> iterator) {
        return new Iterable<U>(){

            @Override
            public Iterator<U> iterator() {
                return iterator;
            }
        };
    }

    public static <U> Set<U> set() {
        return new HashSet();
    }

    public static <U> Set<U> set(U ... us) throws IllegalArgumentException {
        return CollectionTools.collection(new HashSet(), us);
    }

    public static <U> Set<U> set(Iterable<U> us) throws IllegalArgumentException {
        return CollectionTools.collection(new HashSet(), us);
    }

    public static <U> List<U> list() {
        return new ArrayList();
    }

    public static <U> List<U> list(U ... us) throws IllegalArgumentException {
        return CollectionTools.collection(new ArrayList(), us);
    }

    public static <U> List<U> list(Iterable<U> us) throws IllegalArgumentException {
        return CollectionTools.collection(new ArrayList(), us);
    }

    private static <U, T extends Collection<U>> T collection(T collection, U ... us) {
        if (us == null) {
            throw new IllegalArgumentException("No null array accepted");
        }
        for (U u : us) {
            collection.add(u);
        }
        return collection;
    }

    private static <U, T extends Collection<U>> T collection(T collection, Iterable<U> us) {
        if (us == null) {
            throw new IllegalArgumentException("No null array accepted");
        }
        for (U u : us) {
            collection.add(u);
        }
        return collection;
    }
}

