/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.environment.deployment.AbstractWeldDeployment;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.resources.spi.ResourceLoader;

public class WeldDeployment
extends AbstractWeldDeployment {
    public static final String ADDITIONAL_BDA_ID = WeldDeployment.class.getName() + ".additionalClasses";
    public static final String SYNTHETIC_BDA_ID = WeldDeployment.class.getName() + ".synthetic";
    private final Set<WeldBeanDeploymentArchive> beanDeploymentArchives;
    private final ResourceLoader resourceLoader;
    private WeldBeanDeploymentArchive additionalBeanDeploymentArchive = null;

    public WeldDeployment(ResourceLoader resourceLoader, Bootstrap bootstrap, Set<WeldBeanDeploymentArchive> beanDeploymentArchives, Iterable<Metadata<Extension>> extensions) {
        super(bootstrap, extensions);
        this.resourceLoader = resourceLoader;
        this.beanDeploymentArchives = beanDeploymentArchives;
        this.setBeanDeploymentArchivesAccessibility();
    }

    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return Collections.unmodifiableSet(this.beanDeploymentArchives);
    }

    public BeanDeploymentArchive loadBeanDeploymentArchive(Class<?> beanClass) {
        if (this.beanDeploymentArchives.size() == 1) {
            return this.beanDeploymentArchives.iterator().next();
        }
        BeanDeploymentArchive bda = this.getBeanDeploymentArchive(beanClass);
        return bda != null ? bda : this.createAdditionalBeanDeploymentArchiveIfNeeded(beanClass);
    }

    public BeanDeploymentArchive getBeanDeploymentArchive(Class<?> beanClass) {
        for (BeanDeploymentArchive beanDeploymentArchive : this.beanDeploymentArchives) {
            if (!beanDeploymentArchive.getBeanClasses().contains(beanClass.getName())) continue;
            return beanDeploymentArchive;
        }
        return null;
    }

    protected BeanDeploymentArchive createAdditionalBeanDeploymentArchiveIfNeeded(Class<?> beanClass) {
        if (this.additionalBeanDeploymentArchive == null) {
            this.additionalBeanDeploymentArchive = this.createAdditionalBeanDeploymentArchive(beanClass);
        } else {
            this.additionalBeanDeploymentArchive.addBeanClass(beanClass.getName());
        }
        return this.additionalBeanDeploymentArchive;
    }

    protected WeldBeanDeploymentArchive createAdditionalBeanDeploymentArchive(Class<?> beanClass) {
        HashSet<String> beanClasses = new HashSet<String>();
        beanClasses.add(beanClass.getName());
        WeldBeanDeploymentArchive additionalBda = new WeldBeanDeploymentArchive(ADDITIONAL_BDA_ID, beanClasses, null);
        additionalBda.getServices().add(ResourceLoader.class, (Service)this.resourceLoader);
        additionalBda.getServices().addAll((Collection)this.getServices().entrySet());
        this.beanDeploymentArchives.add(additionalBda);
        this.setBeanDeploymentArchivesAccessibility();
        return additionalBda;
    }

    protected void setBeanDeploymentArchivesAccessibility() {
        for (WeldBeanDeploymentArchive archive : this.beanDeploymentArchives) {
            archive.setAccessibleBeanDeploymentArchives(this.beanDeploymentArchives);
        }
    }
}

