/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.reflect.Type;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.weld.annotated.AnnotatedTypeValidator;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.bootstrap.events.AbstractDefinitionContainerEvent;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeEventResolvable;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.spi.AnnotationDiscovery;

public class ProcessAnnotatedTypeImpl<X>
extends AbstractDefinitionContainerEvent
implements ProcessAnnotatedType<X> {
    private final SlimAnnotatedType<X> originalAnnotatedType;
    private AnnotatedType<X> annotatedType;
    private boolean veto;
    private final Resolvable resolvable;

    public ProcessAnnotatedTypeImpl(BeanManagerImpl beanManager, SlimAnnotatedType<X> annotatedType, AnnotationDiscovery discovery) {
        this(beanManager, annotatedType, ProcessAnnotatedType.class, discovery);
    }

    protected ProcessAnnotatedTypeImpl(BeanManagerImpl beanManager, SlimAnnotatedType<X> annotatedType, Class<? extends ProcessAnnotatedType> rawType, AnnotationDiscovery discovery) {
        super(beanManager, rawType, new Type[]{annotatedType.getJavaClass()});
        this.annotatedType = annotatedType;
        this.originalAnnotatedType = annotatedType;
        this.resolvable = this.createResolvable(annotatedType, discovery);
    }

    @Override
    public AnnotatedType<X> getAnnotatedType() {
        return this.annotatedType;
    }

    public SlimAnnotatedType<X> getResultingAnnotatedType() {
        if (this.isDirty()) {
            return ClassTransformer.instance(this.getBeanManager()).getUnbackedAnnotatedType(this.originalAnnotatedType, this.annotatedType);
        }
        return this.originalAnnotatedType;
    }

    @Override
    public void setAnnotatedType(AnnotatedType<X> type) {
        if (type == null) {
            throw new IllegalArgumentException(BootstrapMessage.ANNOTATION_TYPE_NULL, this);
        }
        if (!this.originalAnnotatedType.getJavaClass().equals(type.getJavaClass())) {
            throw new IllegalArgumentException(BootstrapMessage.ANNOTATED_TYPE_JAVA_CLASS_MISMATCH, this.annotatedType.getJavaClass(), type.getJavaClass());
        }
        AnnotatedTypeValidator.validateAnnotatedType(type);
        this.annotatedType = type;
    }

    protected Resolvable createResolvable(SlimAnnotatedType<X> annotatedType, AnnotationDiscovery discovery) {
        return ProcessAnnotatedTypeEventResolvable.forProcessAnnotatedType(annotatedType, discovery);
    }

    @Override
    public void fire() {
        try {
            this.getBeanManager().getGlobalLenientObserverNotifier().fireEvent((Object)this, this.resolvable);
        }
        catch (Exception e) {
            this.getErrors().add(e);
        }
        if (!this.getErrors().isEmpty()) {
            throw new DefinitionException(this.getErrors());
        }
    }

    @Override
    public void veto() {
        this.veto = true;
    }

    public boolean isVeto() {
        return this.veto;
    }

    public boolean isDirty() {
        return this.originalAnnotatedType != this.annotatedType;
    }

    public String toString() {
        return this.annotatedType.toString();
    }
}

