/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.contexts.unbound;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import javax.enterprise.context.RequestScoped;
import org.jboss.weld.context.RequestContext;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.contexts.AbstractUnboundContext;
import org.jboss.weld.contexts.beanstore.HashMapBeanStore;
import org.jboss.weld.contexts.cache.RequestScopedCache;
import org.jboss.weld.serialization.spi.BeanIdentifier;

public class RequestContextImpl
extends AbstractUnboundContext
implements RequestContext {
    public RequestContextImpl(String contextId) {
        super(contextId, false);
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    @Override
    public void activate() {
        this.setBeanStore(new HashMapBeanStore());
        super.activate();
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.setBeanStore(null);
        this.cleanup();
    }

    @Override
    public Collection<ContextualInstance<?>> getAllContextualInstances() {
        HashSet result = new HashSet();
        this.getBeanStore().iterator().forEachRemaining(beanId -> result.add(this.getBeanStore().get((BeanIdentifier)beanId)));
        return result;
    }

    @Override
    public void clearAndSet(Collection<ContextualInstance<?>> setOfInstances) {
        this.getBeanStore().clear();
        RequestScopedCache.invalidate();
        for (ContextualInstance<?> contextualInstance : setOfInstances) {
            this.getBeanStore().put(this.getId(contextualInstance.getContextual()), contextualInstance);
        }
    }
}

