/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContainerEvent {
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final BeanManagerImpl beanManager;
    private final Type[] actualTypeArguments;
    private final Type rawType;

    protected AbstractContainerEvent(BeanManagerImpl beanManager, Type rawType, Type[] actualTypeArguments) {
        this.beanManager = beanManager;
        this.actualTypeArguments = actualTypeArguments;
        this.rawType = rawType;
    }

    protected List<Throwable> getErrors() {
        return this.errors;
    }

    protected BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    protected void fire() {
        ParameterizedTypeImpl eventType = new ParameterizedTypeImpl(this.getRawType(), this.getActualTypeArguments(), null);
        try {
            this.beanManager.fireEvent((Type)eventType, (Object)this, new Annotation[0]);
        }
        catch (Exception e) {
            this.getErrors().add(e);
        }
    }

    protected void fire(Map<BeanDeploymentArchive, BeanDeployment> beanDeployments) {
        try {
            HashSet observers = new HashSet();
            ParameterizedTypeImpl eventType = new ParameterizedTypeImpl(this.getRawType(), this.getActualTypeArguments(), null);
            for (BeanDeployment beanDeployment : beanDeployments.values()) {
                observers.addAll(beanDeployment.getBeanManager().resolveObserverMethods((Type)eventType, new Annotation[0]));
            }
            for (ObserverMethod observerMethod : observers) {
                observerMethod.notify(this);
            }
        }
        catch (Exception e) {
            this.getErrors().add(e);
        }
    }

    protected Type getRawType() {
        return this.rawType;
    }

    protected Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }
}

