/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.servlet.Listener;
import org.jboss.weld.environment.servlet.deployment.URLScanner;

public class ExactListener
extends Listener {
    public static final String BEAN_CLASSES = "bean-classes.txt";

    protected URLScanner createUrlScanner(ClassLoader classLoader, ServletContext context) {
        return new ExactScanner(classLoader, context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExactScanner
    extends URLScanner {
        private ServletContext context;

        private ExactScanner(ClassLoader classLoader, ServletContext context) {
            super(classLoader);
            if (context == null) {
                throw new IllegalArgumentException("Null context");
            }
            this.context = context;
        }

        protected URL getExactBeansURL() {
            try {
                URL url = this.context.getResource("/WEB-INF/bean-classes.txt");
                if (url == null) {
                    url = this.getClassLoader().getResource(ExactListener.BEAN_CLASSES);
                }
                return url;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scanResources(String[] resources, Set<String> classes, Set<URL> urls) {
            URL url = this.getExactBeansURL();
            if (url == null) {
                throw new IllegalArgumentException("Missing exact beans resource: bean-classes.txt");
            }
            try {
                InputStream is = url.openStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("#")) continue;
                        classes.add(line);
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

