/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.net.URL;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import org.jboss.logging.Logger;
import org.jboss.weld.environment.servlet.deployment.URLScanner;

public class TomcatScanner
extends URLScanner {
    private static final Logger log = Logger.getLogger(TomcatScanner.class);

    public TomcatScanner(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected void handleURL(URL url, Set<String> classes, Set<URL> urls) {
        try {
            Object content = url.getContent();
            if (content instanceof DirContext) {
                this.recurse((DirContext)content, classes, urls, "");
            } else {
                log.warn("Cannot scan URL, content not javax.naming.Context instance.");
            }
        }
        catch (Exception e) {
            log.error((Object)("Cannot scan URL: " + url), e);
        }
    }

    @Override
    protected boolean isURLHandlingSupported() {
        return true;
    }

    protected void recurse(DirContext context, Set<String> classes, Set<URL> urls, String prefix) throws Exception {
        if (prefix.length() > 0) {
            prefix = prefix + ".";
        }
        NamingEnumeration<Binding> ne = context.listBindings("");
        while (ne.hasMoreElements()) {
            Binding next = (Binding)ne.nextElement();
            String name = prefix + next.getName();
            String classFilenameExtension = ".class";
            if (name.endsWith(".class")) {
                classes.add(name.substring(0, name.length() - ".class".length()));
                continue;
            }
            Object nextObject = next.getObject();
            if (!(nextObject instanceof DirContext)) continue;
            this.recurse((DirContext)nextObject, classes, urls, name);
        }
    }
}

