/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.inject;

import java.util.Map;
import java.util.WeakHashMap;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.manager.api.WeldManager;

public abstract class AbstractInjector {
    private final WeldManager manager;
    private final Map<Class<?>, InjectionTarget<?>> cache = new WeakHashMap();

    protected AbstractInjector(WeldManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Null manager");
        }
        this.manager = manager;
    }

    protected void inject(Object instance) {
        Class<?> clazz = instance.getClass();
        if (!this.cache.containsKey(clazz)) {
            this.cache.put(clazz, this.manager.createInjectionTarget(this.manager.createAnnotatedType(clazz)));
        }
        WeldCreationalContext cc = this.manager.createCreationalContext(null);
        InjectionTarget<?> it = this.cache.get(clazz);
        it.inject(instance, cc);
    }

    public void destroy(Object instance) {
        if (instance != null) {
            AnnotatedType<?> type = this.manager.createAnnotatedType(instance.getClass());
            InjectionTarget<?> it = this.manager.createInjectionTarget(type);
            it.dispose(instance);
        }
    }
}

