/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.bean.BeanIdentifiers;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Proxies;

public class ExtensionBean<E extends Extension>
extends AbstractBuiltInBean<E> {
    private final SlimAnnotatedType<E> annotatedType;
    private final Metadata<E> instance;
    private final boolean passivationCapable;
    private final boolean proxiable;

    public ExtensionBean(BeanManagerImpl manager, EnhancedAnnotatedType<E> enhancedAnnotatedType, Metadata<E> instance) {
        super(new StringBeanIdentifier(BeanIdentifiers.forExtension(enhancedAnnotatedType)), manager, enhancedAnnotatedType.getJavaClass());
        this.annotatedType = enhancedAnnotatedType.slim();
        this.instance = instance;
        this.passivationCapable = enhancedAnnotatedType.isSerializable();
        this.proxiable = Proxies.isTypeProxyable(enhancedAnnotatedType.getBaseType(), manager.getServices());
        this.checkPublicFields(enhancedAnnotatedType);
    }

    private void checkPublicFields(EnhancedAnnotatedType<E> clazz) {
        for (AnnotatedField field : clazz.getFields()) {
            Field member = field.getJavaMember();
            if (!Modifier.isPublic(member.getModifiers()) || Modifier.isStatic(member.getModifiers())) continue;
            BeanLogger.LOG.extensionWithNonStaticPublicField(clazz.getBaseType(), field.getJavaMember());
        }
    }

    @Override
    public Set<Type> getTypes() {
        return this.annotatedType.getTypeClosure();
    }

    @Override
    public boolean isProxyable() {
        return this.proxiable;
    }

    @Override
    public boolean isPassivationCapableBean() {
        return this.passivationCapable;
    }

    @Override
    public E create(CreationalContext<E> creationalContext) {
        return (E)((Extension)this.instance.getValue());
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public SlimAnnotatedType<E> getAnnotatedType() {
        return this.annotatedType;
    }

    @Override
    public String toString() {
        return "Extension [" + this.getType().toString() + "] with qualifiers [@Default]; " + this.instance.getLocation();
    }
}

