/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.util.HashMap;
import java.util.Map;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableMap;
import org.jboss.weld.util.reflection.Reflections;

public final class Primitives {
    private static final String ARG_TYPE = "type";
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE;

    private Primitives() {
    }

    private static void put(Map<Class<?>, Class<?>> primitiveToWrapper, Map<Class<?>, Class<?>> wrapperToPrimitive, Class<?> primitive, Class<?> wrapper) {
        primitiveToWrapper.put(primitive, wrapper);
        wrapperToPrimitive.put(wrapper, primitive);
    }

    public static <T> Class<T> wrap(Class<T> type) {
        Preconditions.checkArgumentNotNull(type, ARG_TYPE);
        Class<T> wrapped = (Class<T>)Reflections.cast(PRIMITIVE_TO_WRAPPER.get(type));
        return wrapped != null ? wrapped : type;
    }

    public static <T> Class<T> unwrap(Class<T> type) {
        Preconditions.checkArgumentNotNull(type, ARG_TYPE);
        Class<T> primitive = (Class<T>)Reflections.cast(WRAPPER_TO_PRIMITIVE.get(type));
        return primitive != null ? primitive : type;
    }

    static {
        HashMap primitiveToWrapper = new HashMap();
        HashMap wrapperToPrimitive = new HashMap();
        Primitives.put(primitiveToWrapper, wrapperToPrimitive, Boolean.TYPE, Boolean.class);
        Primitives.put(primitiveToWrapper, wrapperToPrimitive, Character.TYPE, Character.class);
        Primitives.put(primitiveToWrapper, wrapperToPrimitive, Short.TYPE, Short.class);
        Primitives.put(primitiveToWrapper, wrapperToPrimitive, Integer.TYPE, Integer.class);
        Primitives.put(primitiveToWrapper, wrapperToPrimitive, Long.TYPE, Long.class);
        Primitives.put(primitiveToWrapper, wrapperToPrimitive, Double.TYPE, Double.class);
        Primitives.put(primitiveToWrapper, wrapperToPrimitive, Float.TYPE, Float.class);
        Primitives.put(primitiveToWrapper, wrapperToPrimitive, Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER = ImmutableMap.builder().putAll(primitiveToWrapper).build();
        WRAPPER_TO_PRIMITIVE = ImmutableMap.builder().putAll(wrapperToPrimitive).build();
    }
}

