/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EmptyStackException;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.context.cache.RequestScopedCache;
import org.jboss.weld.context.cache.RequestScopedItem;

public class InterceptionDecorationContext {
    private static ThreadLocal<Stack> interceptionContexts = new ThreadLocal();

    private InterceptionDecorationContext() {
    }

    public static CombinedInterceptorAndDecoratorStackMethodHandler peek() {
        return InterceptionDecorationContext.peek(interceptionContexts.get());
    }

    public static CombinedInterceptorAndDecoratorStackMethodHandler peekIfNotEmpty() {
        Stack stack = interceptionContexts.get();
        if (stack == null) {
            return null;
        }
        return stack.peek();
    }

    public static boolean empty() {
        return InterceptionDecorationContext.empty(interceptionContexts.get());
    }

    public static void endInterceptorContext() {
        InterceptionDecorationContext.pop(interceptionContexts.get());
    }

    public static Stack startIfNotEmpty() {
        Stack stack = interceptionContexts.get();
        if (InterceptionDecorationContext.empty(stack)) {
            return null;
        }
        stack.push(CombinedInterceptorAndDecoratorStackMethodHandler.NULL_INSTANCE);
        return stack;
    }

    public static Stack startIfNotOnTop(CombinedInterceptorAndDecoratorStackMethodHandler context) {
        Stack stack = InterceptionDecorationContext.getStack();
        if (stack.startIfNotOnTop(context)) {
            return stack;
        }
        return null;
    }

    public static Stack getStack() {
        Stack stack = interceptionContexts.get();
        if (stack == null) {
            stack = new Stack(interceptionContexts);
            interceptionContexts.set(stack);
        }
        return stack;
    }

    private static CombinedInterceptorAndDecoratorStackMethodHandler pop(Stack stack) {
        if (stack == null) {
            throw new EmptyStackException();
        }
        return stack.pop();
    }

    private static CombinedInterceptorAndDecoratorStackMethodHandler peek(Stack stack) {
        if (stack == null) {
            throw new EmptyStackException();
        }
        return stack.peek();
    }

    private static boolean empty(Stack stack) {
        if (stack == null) {
            return true;
        }
        return stack.elements.isEmpty();
    }

    public static class Stack
    implements RequestScopedItem {
        private boolean removeWhenEmpty;
        private final Deque<CombinedInterceptorAndDecoratorStackMethodHandler> elements;
        private final ThreadLocal<Stack> interceptionContexts;
        private boolean valid;

        private Stack(ThreadLocal<Stack> interceptionContexts) {
            this.interceptionContexts = interceptionContexts;
            this.elements = new ArrayDeque<CombinedInterceptorAndDecoratorStackMethodHandler>();
            this.removeWhenEmpty = !RequestScopedCache.addItemIfActive(this);
            this.valid = true;
        }

        public boolean startIfNotOnTop(CombinedInterceptorAndDecoratorStackMethodHandler context) {
            this.checkState();
            if (this.elements.isEmpty() || this.peek() != context) {
                this.push(context);
                return true;
            }
            return false;
        }

        public void end() {
            this.pop();
        }

        private void push(CombinedInterceptorAndDecoratorStackMethodHandler item) {
            this.checkState();
            this.elements.addFirst(item);
        }

        public CombinedInterceptorAndDecoratorStackMethodHandler peek() {
            this.checkState();
            return this.elements.peekFirst();
        }

        private CombinedInterceptorAndDecoratorStackMethodHandler pop() {
            this.checkState();
            CombinedInterceptorAndDecoratorStackMethodHandler top = this.elements.removeFirst();
            this.removeIfEmpty();
            return top;
        }

        private void checkState() {
            if (!this.valid) {
                throw new IllegalStateException("This InterceptionDecorationContext is no longer valid.");
            }
        }

        @Override
        public void invalidate() {
            this.removeWhenEmpty = true;
            this.removeIfEmpty();
        }

        private void removeIfEmpty() {
            if (this.removeWhenEmpty && this.elements.isEmpty()) {
                this.interceptionContexts.remove();
                this.valid = false;
            }
        }

        public int size() {
            return this.elements.size();
        }

        public String toString() {
            return "Stack [valid=" + this.valid + ", cached=" + !this.removeWhenEmpty + ", elements=" + this.elements + "]";
        }
    }
}

