/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.logging;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.weld.context.BusyConversationException;
import org.jboss.weld.context.NonexistentConversationException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.WeldLogger;

@MessageLogger(projectCode="WELD-")
public interface ConversationLogger
extends WeldLogger {
    public static final ConversationLogger LOG = (ConversationLogger)Logger.getMessageLogger(ConversationLogger.class, (String)Category.CONVERSATION.getName());

    @Deprecated
    @Message(id=300, value="No conversation id to restore")
    public String noConversationToRestore();

    @Deprecated
    @Message(id=301, value="Could not restore long-running conversation {0} because {1}", format=Message.Format.MESSAGE_FORMAT)
    public String unableToRestoreConversation(Object var1, Object var2);

    @Deprecated
    @Message(id=302, value="Interrupted while trying to acquire lock")
    public String conversationLockUnavailable();

    @Deprecated
    @Message(id=303, value="Conversation switched from {0} to {1}", format=Message.Format.MESSAGE_FORMAT)
    public String conversationSwitched(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=304, value="Cleaning up conversation {0}", format=Message.Format.MESSAGE_FORMAT)
    public void cleaningUpConversation(Object var1);

    @Deprecated
    @Message(id=305, value="Scheduled {0} for termination", format=Message.Format.MESSAGE_FORMAT)
    public String conversationTerminationScheduled(Object var1);

    @Deprecated
    @Message(id=306, value="Termination of conversation {0} cancelled", format=Message.Format.MESSAGE_FORMAT)
    public String conversationTerminationCancelled(Object var1);

    @Deprecated
    @Message(id=307, value="Failed to cancel termination of conversation {0}", format=Message.Format.MESSAGE_FORMAT)
    public String conversationTerminationCancellationFailed(Object var1);

    @Deprecated
    @Message(id=308, value="Destroyed long-running conversation {0} because {1}", format=Message.Format.MESSAGE_FORMAT)
    public String destroyLrcComplete(Object var1, Object var2);

    @Deprecated
    @Message(id=309, value="{0} long-running conversations", format=Message.Format.MESSAGE_FORMAT)
    public String lrcCount(Object var1);

    @Deprecated
    @Message(id=310, value="Destroying transient conversation {0}", format=Message.Format.MESSAGE_FORMAT)
    public String destroyTransientConversation(Object var1);

    @Deprecated
    @Message(id=311, value="Destroying long-running conversation {0} because {1}", format=Message.Format.MESSAGE_FORMAT)
    public String destroyLrc(Object var1, Object var2);

    @Deprecated
    @Message(id=312, value="Destroying all long-running conversations because {0}", format=Message.Format.MESSAGE_FORMAT)
    public String destroyAllLrc(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=313, value="Lock acquired on conversation {0}", format=Message.Format.MESSAGE_FORMAT)
    public void conversationLocked(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=314, value="Lock released on conversation {0}", format=Message.Format.MESSAGE_FORMAT)
    public void conversationUnlocked(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=315, value="Failed to acquire conversation lock in {0} ms for {1}", format=Message.Format.MESSAGE_FORMAT)
    public void conversationUnavailable(Object var1, Object var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=316, value="Attempt to release lock on conversation {0} failed because {1}", format=Message.Format.MESSAGE_FORMAT)
    public void illegalConversationUnlockAttempt(Object var1, Object var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=317, value="Promoted conversation {0} to long-running", format=Message.Format.MESSAGE_FORMAT)
    public void promotedTransient(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=318, value="Returned long-running conversation {0} to transient", format=Message.Format.MESSAGE_FORMAT)
    public void demotedLrc(Object var1);

    @Deprecated
    @Message(id=319, value="Switched conversation from {0} to {1}", format=Message.Format.MESSAGE_FORMAT)
    public String switchedConversation(Object var1, Object var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=320, value="Cleaning up transient conversation")
    public void cleaningUpTransientConversation();

    @Message(id=321, value="No conversation found to restore for id {0}", format=Message.Format.MESSAGE_FORMAT)
    public NonexistentConversationException noConversationFoundToRestore(Object var1);

    @Message(id=322, value="Conversation lock timed out: {0}", format=Message.Format.MESSAGE_FORMAT)
    public BusyConversationException conversationLockTimedout(Object var1);

    @Deprecated
    @Message(id=323, value="Cleaning up the conversation after the {0} phase because {1}", format=Message.Format.MESSAGE_FORMAT)
    public String cleaningUpConversation(Object var1, Object var2);

    @Deprecated
    @Message(id=324, value="Skipping conversation cleanup after the {0} phase because {1}", format=Message.Format.MESSAGE_FORMAT)
    public String skippingCleaningUpConversation(Object var1, Object var2);

    @Deprecated
    @Message(id=325, value="Initiating conversation before the {0} phase", format=Message.Format.MESSAGE_FORMAT)
    public String initiatingConversation(Object var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=326, value="Found conversation id {0} in request parameter", format=Message.Format.MESSAGE_FORMAT)
    public void foundConversationFromRequest(Object var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=327, value="Resuming conversation with id {0}", format=Message.Format.MESSAGE_FORMAT)
    public void resumingConversation(Object var1);

    @Message(id=328, value="Attempt to call begin() on a long-running conversation")
    public IllegalStateException beginCalledOnLongRunningConversation();

    @Message(id=329, value="Attempt to call end() on a transient conversation")
    public IllegalStateException endCalledOnTransientConversation();

    @Deprecated
    @Message(id=330, value="Cannot create ConversationBeanStore with a null HTTP session")
    public String nullHttpSession();

    @Deprecated
    @Message(id=331, value="Switching modes with non-transient conversations present resets the timeouts")
    public String switchingModeResetsTimeouts();

    @Message(id=332, value="Conversation ID {0} is already in use", format=Message.Format.MESSAGE_FORMAT)
    public IllegalArgumentException conversationIdAlreadyInUse(Object var1);

    @Message(id=333, value="Must call associate() before calling activate()", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException mustCallAssociateBeforeActivate();

    @Message(id=334, value="Must call associate() before calling deactivate()", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException mustCallAssociateBeforeDeactivate();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=335, value="Conversation context is already active, most likely it was not cleaned up properly during previous request processing: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void contextAlreadyActive(Object var1);

    @Message(id=336, value="Context is not active", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException contextNotActive();

    @Message(id=337, value="Unable to find ConversationNamingScheme in the request, this conversation wasn't transient at the start of the request", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException conversationNamingSchemeNotFound();

    @Message(id=338, value="Unable to locate ConversationIdGenerator", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException conversationIdGeneratorNotFound();

    @Message(id=339, value="A request must be associated with the context in order to generate a conversation id", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException mustCallAssociateBeforeGeneratingId();

    @Message(id=340, value="A request must be associated with the context in order to load the known conversations", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException mustCallAssociateBeforeLoadingKnownConversations();

    @Message(id=341, value="Unable to load current conversations from the associated request, something went badly wrong when associate() was called", format=Message.Format.MESSAGE_FORMAT)
    public IllegalStateException unableToLoadCurrentConversations();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=342, value="Going to end a locked conversation with id {0}", format=Message.Format.MESSAGE_FORMAT)
    public void endLockedConversation(String var1);
}

