/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.InterceptorResolvable;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;

public class TypeSafeInterceptorResolver
extends TypeSafeResolver<InterceptorResolvable, Interceptor<?>, List<Interceptor<?>>, List<Interceptor<?>>> {
    private final BeanManagerImpl manager;

    public TypeSafeInterceptorResolver(BeanManagerImpl manager, Iterable<Interceptor<?>> interceptors) {
        super(interceptors);
        this.manager = manager;
    }

    @Override
    protected boolean matches(InterceptorResolvable resolvable, Interceptor<?> bean) {
        return bean.intercepts(resolvable.getInterceptionType()) && bean.getInterceptorBindings().size() > 0 && Beans.containsAllInterceptionBindings(bean.getInterceptorBindings(), resolvable.getQualifiers(), this.getManager()) && this.manager.getEnabled().isInterceptorEnabled(bean.getBeanClass());
    }

    @Override
    protected List<Interceptor<?>> sortResult(Set<Interceptor<?>> matchedInterceptors) {
        ArrayList sortedInterceptors = new ArrayList(matchedInterceptors);
        Collections.sort(sortedInterceptors, this.manager.getEnabled().getInterceptorComparator());
        return sortedInterceptors;
    }

    @Override
    protected Set<Interceptor<?>> filterResult(Set<Interceptor<?>> matched) {
        return matched;
    }

    public BeanManagerImpl getManager() {
        return this.manager;
    }
}

