/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;

public abstract class TypeSafeResolver<R extends Resolvable, T, C extends Collection<T>, F> {
    private static final long RESOLVED_CACHE_UPPER_BOUND = Long.getLong("org.jboss.weld.resolution.cacheSize", 0x100000L);
    private static final long DEFAULT_RESOLVED_CACHE_UPPER_BOUND = 0x100000L;
    private final LoadingCache<R, F> resolved;
    private final Iterable<? extends T> allBeans;
    private final ResolvableToBeanCollection<R, T, C, F> resolverFunction = new ResolvableToBeanCollection(this);

    public TypeSafeResolver(Iterable<? extends T> allBeans) {
        this.resolved = CacheBuilder.newBuilder().maximumSize(RESOLVED_CACHE_UPPER_BOUND).build(this.resolverFunction);
        this.allBeans = allBeans;
    }

    public void clear() {
        this.resolved.invalidateAll();
        this.resolved.cleanUp();
    }

    public F resolve(R resolvable, boolean cache) {
        R wrappedResolvable = this.wrap(resolvable);
        if (cache) {
            return LoadingCacheUtils.getCacheValue(this.resolved, wrappedResolvable);
        }
        return this.resolverFunction.load(wrappedResolvable);
    }

    private Set<T> findMatching(R resolvable) {
        HashSet<T> result = new HashSet<T>();
        for (T bean : this.getAllBeans(resolvable)) {
            if (!this.matches(resolvable, bean)) continue;
            result.add(bean);
        }
        return result;
    }

    protected Iterable<? extends T> getAllBeans(R resolvable) {
        return this.allBeans;
    }

    protected Iterable<? extends T> getAllBeans() {
        return this.allBeans;
    }

    protected abstract Set<T> filterResult(Set<T> var1);

    protected abstract C sortResult(Set<T> var1);

    protected abstract boolean matches(R var1, T var2);

    protected F makeResultImmutable(C result) {
        if (result instanceof List) {
            return (F)Reflections.cast(WeldCollections.immutableList((List)result));
        }
        if (result instanceof Set) {
            return (F)Reflections.cast(WeldCollections.immutableSet((Set)result));
        }
        throw new IllegalArgumentException("result");
    }

    protected R wrap(R resolvable) {
        return resolvable;
    }

    public boolean isCached(R resolvable) {
        return this.resolved.getIfPresent(this.wrap(resolvable)) != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Resolver\n");
        sb.append("Resolved injection points: ").append(this.resolved.size()).append('\n');
        return sb.toString();
    }

    private static class ResolvableToBeanCollection<R extends Resolvable, T, C extends Collection<T>, F>
    extends CacheLoader<R, F> {
        private final TypeSafeResolver<R, T, C, F> resolver;

        private ResolvableToBeanCollection(TypeSafeResolver<R, T, C, F> resolver) {
            this.resolver = resolver;
        }

        public F load(R from) {
            return this.resolver.makeResultImmutable(this.resolver.sortResult(this.resolver.filterResult(((TypeSafeResolver)this.resolver).findMatching(from))));
        }
    }
}

