/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import jakarta.decorator.Decorator;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.ObservesAsync;
import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.CreationException;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.inject.Inject;
import jakarta.interceptor.Interceptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.ForwardingBean;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.enablement.ModuleEnablement;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ResourceInjection;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionTypeRegistry;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.MetadataLogger;
import org.jboss.weld.logging.UtilLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MergedStereotypes;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resources.spi.ClassFileInfo;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public class Beans {
    private Beans() {
    }

    public static boolean isPassivatingScope(Bean<?> bean, BeanManagerImpl manager) {
        if (bean == null) {
            return false;
        }
        return ((MetaAnnotationStore)manager.getServices().get(MetaAnnotationStore.class)).getScopeModel(bean.getScope()).isPassivating();
    }

    public static boolean isPassivationCapableBean(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isPassivationCapableBean();
        }
        return bean instanceof PassivationCapable;
    }

    public static boolean isPassivationCapableDependency(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isPassivationCapableDependency();
        }
        return bean instanceof PassivationCapable;
    }

    public static boolean isBeanProxyable(Bean<?> bean, BeanManagerImpl manager) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isProxyable();
        }
        return Proxies.isTypesProxyable(bean.getTypes(), manager.getServices());
    }

    public static List<EnhancedAnnotatedMethod<?, ?>> getInterceptableMethods(EnhancedAnnotatedType<?> type) {
        ArrayList annotatedMethods = new ArrayList();
        for (EnhancedAnnotatedMethod<?, ?> annotatedMethod : type.getEnhancedMethods()) {
            boolean businessMethod = !annotatedMethod.isStatic() && !annotatedMethod.isAnnotationPresent(Inject.class) && !annotatedMethod.getJavaMember().isBridge();
            if (!businessMethod || Beans.isInterceptorMethod(annotatedMethod)) continue;
            annotatedMethods.add(annotatedMethod);
        }
        return annotatedMethods;
    }

    private static boolean isInterceptorMethod(AnnotatedMethod<?> annotatedMethod) {
        for (InterceptionType interceptionType : InterceptionTypeRegistry.getSupportedInterceptionTypes()) {
            if (!annotatedMethod.isAnnotationPresent(InterceptionTypeRegistry.getAnnotationClass(interceptionType))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllQualifiers(Set<QualifierInstance> requiredQualifiers, Set<QualifierInstance> qualifiers) {
        return qualifiers.containsAll(requiredQualifiers);
    }

    public static boolean containsAllInterceptionBindings(Set<Annotation> expectedBindings, Set<QualifierInstance> existingBindings, BeanManagerImpl manager) {
        Set<QualifierInstance> expected = manager.extractInterceptorBindingsForQualifierInstance(QualifierInstance.of(expectedBindings, (MetaAnnotationStore)manager.getServices().get(MetaAnnotationStore.class)));
        return expected.isEmpty() ? false : manager.extractInterceptorBindingsForQualifierInstance(existingBindings).containsAll(expected);
    }

    public static <T extends Bean<?>> Set<T> removeDisabledBeans(Set<T> beans, BeanManagerImpl beanManager) {
        if (beans.isEmpty()) {
            return beans;
        }
        Iterator<T> iterator = beans.iterator();
        while (iterator.hasNext()) {
            if (Beans.isBeanEnabled((Bean)iterator.next(), beanManager.getEnabled())) continue;
            iterator.remove();
        }
        return beans;
    }

    public static boolean isBeanEnabled(Bean<?> bean, ModuleEnablement enabled) {
        if (bean.isAlternative()) {
            if (enabled.isEnabledAlternativeClass(bean.getBeanClass())) {
                return true;
            }
            for (Class stereotype : bean.getStereotypes()) {
                if (!enabled.isEnabledAlternativeStereotype(stereotype)) continue;
                return true;
            }
            return false;
        }
        if (bean instanceof AbstractProducerBean) {
            AbstractProducerBean receiverBean = (AbstractProducerBean)bean;
            return Beans.isBeanEnabled(receiverBean.getDeclaringBean(), enabled);
        }
        if (bean instanceof DecoratorImpl) {
            return enabled.isDecoratorEnabled(bean.getBeanClass());
        }
        if (bean instanceof InterceptorImpl) {
            return enabled.isInterceptorEnabled(bean.getBeanClass());
        }
        return true;
    }

    public static boolean isAlternative(EnhancedAnnotated<?, ?> annotated, MergedStereotypes<?, ?> mergedStereotypes) {
        return annotated.isAnnotationPresent(Alternative.class) || mergedStereotypes.isAlternative();
    }

    public static <T> EnhancedAnnotatedConstructor<T> getBeanConstructorStrict(EnhancedAnnotatedType<T> type) {
        EnhancedAnnotatedConstructor<T> constructor = Beans.getBeanConstructor(type);
        if (constructor == null) {
            throw UtilLogger.LOG.unableToFindConstructor(type);
        }
        return constructor;
    }

    public static <T> EnhancedAnnotatedConstructor<T> getBeanConstructor(EnhancedAnnotatedType<T> type) {
        Collection<EnhancedAnnotatedConstructor<T>> initializerAnnotatedConstructors = type.getEnhancedConstructors(Inject.class);
        BeanLogger.LOG.foundInjectableConstructors(initializerAnnotatedConstructors, type);
        EnhancedAnnotatedConstructor<T> constructor = null;
        if (initializerAnnotatedConstructors.size() > 1) {
            throw UtilLogger.LOG.ambiguousConstructor(type, initializerAnnotatedConstructors);
        }
        if (initializerAnnotatedConstructors.size() == 1) {
            constructor = initializerAnnotatedConstructors.iterator().next();
            BeanLogger.LOG.foundOneInjectableConstructor(constructor, type);
        } else if (type.getNoArgsEnhancedConstructor() != null) {
            constructor = type.getNoArgsEnhancedConstructor();
            BeanLogger.LOG.foundDefaultConstructor(constructor, type);
        }
        if (constructor != null) {
            if (!constructor.getEnhancedParameters(Disposes.class).isEmpty()) {
                throw BeanLogger.LOG.parameterAnnotationNotAllowedOnConstructor("@Disposes", constructor, Formats.formatAsStackTraceElement(constructor.getJavaMember()));
            }
            if (!constructor.getEnhancedParameters(Observes.class).isEmpty()) {
                throw BeanLogger.LOG.parameterAnnotationNotAllowedOnConstructor("@Observes", constructor, Formats.formatAsStackTraceElement(constructor.getJavaMember()));
            }
            if (!constructor.getEnhancedParameters(ObservesAsync.class).isEmpty()) {
                throw BeanLogger.LOG.parameterAnnotationNotAllowedOnConstructor("@ObservesAsync", constructor, Formats.formatAsStackTraceElement(constructor.getJavaMember()));
            }
        }
        return constructor;
    }

    public static <T> void injectEEFields(Iterable<Set<ResourceInjection<?>>> resourceInjectionsHierarchy, T beanInstance, CreationalContext<T> ctx) {
        for (Set<ResourceInjection<?>> resourceInjections : resourceInjectionsHierarchy) {
            for (ResourceInjection<T> resourceInjection : resourceInjections) {
                resourceInjection.injectResourceReference(beanInstance, ctx);
            }
        }
    }

    public static Type getDeclaredBeanType(Class<?> clazz) {
        Type[] actualTypeArguments = Reflections.getActualTypeArguments(clazz);
        if (actualTypeArguments.length == 1) {
            return actualTypeArguments[0];
        }
        return null;
    }

    public static <T> void injectBoundFields(T instance, CreationalContext<T> creationalContext, BeanManagerImpl manager, Iterable<? extends FieldInjectionPoint<?, ?>> injectableFields) {
        for (FieldInjectionPoint<T, T> fieldInjectionPoint : injectableFields) {
            fieldInjectionPoint.inject(instance, manager, creationalContext);
        }
    }

    public static <T> void injectFieldsAndInitializers(T instance, CreationalContext<T> ctx, BeanManagerImpl beanManager, List<? extends Iterable<? extends FieldInjectionPoint<?, ?>>> injectableFields, List<? extends Iterable<? extends MethodInjectionPoint<?, ?>>> initializerMethods) {
        if (injectableFields.size() != initializerMethods.size()) {
            throw UtilLogger.LOG.invalidQuantityInjectableFieldsAndInitializerMethods(injectableFields, initializerMethods);
        }
        for (int i = 0; i < injectableFields.size(); ++i) {
            Beans.injectBoundFields(instance, ctx, beanManager, injectableFields.get(i));
            Beans.callInitializers(instance, ctx, beanManager, initializerMethods.get(i));
        }
    }

    public static <T> void callInitializers(T instance, CreationalContext<T> creationalContext, BeanManagerImpl manager, Iterable<? extends MethodInjectionPoint<?, ?>> initializerMethods) {
        for (MethodInjectionPoint<T, T> methodInjectionPoint : initializerMethods) {
            methodInjectionPoint.invoke(instance, null, manager, creationalContext, CreationException.class);
        }
    }

    public static <T> boolean isInterceptor(AnnotatedType<T> annotatedItem) {
        return annotatedItem.isAnnotationPresent(Interceptor.class);
    }

    public static <T> boolean isDecorator(EnhancedAnnotatedType<T> annotatedItem) {
        return annotatedItem.isAnnotationPresent(Decorator.class);
    }

    public static Set<Annotation> mergeInQualifiers(BeanManagerImpl manager, Collection<Annotation> qualifiers, Annotation[] newQualifiers) {
        HashSet<Annotation> result = new HashSet<Annotation>();
        if (qualifiers != null && !qualifiers.isEmpty()) {
            result.addAll(qualifiers);
        }
        if (newQualifiers != null && newQualifiers.length > 0) {
            MetaAnnotationStore store = (MetaAnnotationStore)manager.getServices().get(MetaAnnotationStore.class);
            HashSet<Annotation> checkedNewQualifiers = new HashSet<Annotation>();
            for (Annotation qualifier : newQualifiers) {
                if (!store.getBindingTypeModel(qualifier.annotationType()).isValid()) {
                    throw UtilLogger.LOG.annotationNotQualifier(qualifier);
                }
                Class<? extends Annotation> annotationType = qualifier.annotationType();
                if (!annotationType.isAnnotationPresent(Repeatable.class)) {
                    for (Annotation annotation : checkedNewQualifiers) {
                        if (!annotationType.equals(annotation.annotationType())) continue;
                        throw UtilLogger.LOG.redundantQualifier(qualifier, Arrays.toString(newQualifiers));
                    }
                }
                checkedNewQualifiers.add(qualifier);
            }
            result.addAll(checkedNewQualifiers);
        }
        return result;
    }

    public static Set<Type> getTypes(EnhancedAnnotated<?, ?> annotated) {
        if (annotated.getJavaClass().isArray() || annotated.getJavaClass().isPrimitive()) {
            return ImmutableSet.builder().addAll(annotated.getBaseType(), Object.class).build();
        }
        if (annotated.isAnnotationPresent(Typed.class)) {
            return ImmutableSet.builder().addAll((Iterable<Type>)Beans.getTypedTypes(Reflections.buildTypeMap(annotated.getTypeClosure()), annotated.getJavaClass(), (Typed)annotated.getAnnotation(Typed.class))).build();
        }
        if (annotated.getJavaClass().isInterface()) {
            return Beans.getLegalBeanTypes(annotated.getTypeClosure(), annotated, new Type[]{Object.class});
        }
        return Beans.getLegalBeanTypes(annotated.getTypeClosure(), annotated, new Type[0]);
    }

    public static Set<Type> getTypedTypes(Map<Class<?>, Type> typeClosure, Class<?> rawType, Typed typed) {
        HashSet<Type> types = new HashSet<Type>();
        for (Class specifiedClass : typed.value()) {
            Type tmp = typeClosure.get(specifiedClass);
            if (tmp == null) {
                throw BeanLogger.LOG.typedClassNotInHierarchy(specifiedClass.getName(), rawType, Formats.formatTypes(typeClosure.values()));
            }
            types.add(tmp);
        }
        types.add((Type)((Object)Object.class));
        return types;
    }

    public static boolean isTypeManagedBeanOrDecoratorOrInterceptor(AnnotatedType<?> annotatedType) {
        Class javaClass = annotatedType.getJavaClass();
        return !javaClass.isEnum() && !Extension.class.isAssignableFrom(javaClass) && Reflections.isTopLevelOrStaticNestedClass(javaClass) && !Reflections.isParameterizedTypeWithWildcard(javaClass) && Beans.hasSimpleCdiConstructor(annotatedType);
    }

    public static boolean isTypeManagedBeanOrDecoratorOrInterceptor(ClassFileInfo classFileInfo, boolean checkTypeModifiers) {
        boolean isTypeManagedBean;
        boolean bl = isTypeManagedBean = (classFileInfo.getModifiers() & 0x4000) == 0 && !classFileInfo.isAssignableTo(Extension.class) && classFileInfo.hasCdiConstructor() && (!Modifier.isAbstract(classFileInfo.getModifiers()) || classFileInfo.isAnnotationDeclared(Decorator.class));
        if (checkTypeModifiers) {
            return isTypeManagedBean && (classFileInfo.isTopLevelClass() || Modifier.isStatic(classFileInfo.getModifiers()));
        }
        return isTypeManagedBean;
    }

    public static boolean isDecoratorDeclaringInAppropriateConstructor(ClassFileInfo classFileInfo) {
        return !classFileInfo.hasCdiConstructor() && classFileInfo.isAnnotationDeclared(Decorator.class);
    }

    public static boolean isDecoratorDeclaringInAppropriateConstructor(AnnotatedType<?> annotatedType) {
        return !Beans.hasSimpleCdiConstructor(annotatedType) && annotatedType.isAnnotationPresent(Decorator.class);
    }

    public static boolean hasSimpleCdiConstructor(AnnotatedType<?> type) {
        for (AnnotatedConstructor constructor : type.getConstructors()) {
            if (constructor.getParameters().isEmpty()) {
                return true;
            }
            if (!constructor.isAnnotationPresent(Inject.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVetoed(Class<?> javaClass) {
        if (javaClass.isAnnotationPresent(Vetoed.class)) {
            return true;
        }
        return Beans.isPackageVetoed(javaClass.getPackage());
    }

    public static boolean isVetoed(AnnotatedType<?> type) {
        if (type.isAnnotationPresent(Vetoed.class)) {
            return true;
        }
        return Beans.isPackageVetoed(type.getJavaClass().getPackage());
    }

    private static boolean isPackageVetoed(Package pkg) {
        return pkg != null && pkg.isAnnotationPresent(Vetoed.class);
    }

    public static String createBeanAttributesId(BeanAttributes<?> attributes) {
        StringBuilder builder = new StringBuilder();
        builder.append(attributes.getName());
        builder.append(",");
        builder.append(attributes.getScope().getName());
        builder.append(",");
        builder.append(attributes.isAlternative());
        builder.append(AnnotatedTypes.createAnnotationCollectionId(attributes.getQualifiers()));
        builder.append(Beans.createTypeCollectionId(attributes.getStereotypes()));
        builder.append(Beans.createTypeCollectionId(attributes.getTypes()));
        return builder.toString();
    }

    public static String createTypeCollectionId(Collection<? extends Type> types) {
        StringBuilder builder = new StringBuilder();
        ArrayList<? extends Type> sortedTypes = new ArrayList<Type>(types);
        Collections.sort(sortedTypes, TypeComparator.INSTANCE);
        builder.append("[");
        Iterator iterator = sortedTypes.iterator();
        while (iterator.hasNext()) {
            builder.append(Beans.createTypeId((Type)iterator.next()));
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    private static String createTypeId(Type type) {
        if (type instanceof Class) {
            return ((Class)Reflections.cast(type)).getName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder();
            builder.append(Beans.createTypeId(parameterizedType.getRawType()));
            builder.append("<");
            for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                builder.append(Beans.createTypeId(parameterizedType.getActualTypeArguments()[i]));
                if (i == parameterizedType.getActualTypeArguments().length - 1) continue;
                builder.append(",");
            }
            builder.append(">");
            return builder.toString();
        }
        if (type instanceof TypeVariable) {
            return ((TypeVariable)Reflections.cast(type)).getName();
        }
        if (type instanceof GenericArrayType) {
            return Beans.createTypeId(((GenericArrayType)Reflections.cast(type)).getGenericComponentType());
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static <T, S, X extends EnhancedAnnotated<T, S>> X checkEnhancedAnnotatedAvailable(X enhancedAnnotated) {
        if (enhancedAnnotated == null) {
            throw new IllegalStateException("Enhanced metadata should not be used at runtime.");
        }
        return enhancedAnnotated;
    }

    public static boolean hasBuiltinScope(Bean<?> bean) {
        return RequestScoped.class.equals((Object)bean.getScope()) || SessionScoped.class.equals((Object)bean.getScope()) || ApplicationScoped.class.equals((Object)bean.getScope()) || ConversationScoped.class.equals((Object)bean.getScope()) || Dependent.class.equals((Object)bean.getScope());
    }

    public static Class<? extends Annotation> getBeanDefiningAnnotationScope(AnnotatedType<?> annotatedType) {
        for (Annotation annotation : annotatedType.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(NormalScope.class) && !annotation.annotationType().equals(Dependent.class)) continue;
            return annotation.annotationType();
        }
        return null;
    }

    public static Set<Type> getLegalBeanTypes(Set<Type> types, Object baseType, Type ... additionalTypes) {
        if (additionalTypes != null && additionalTypes.length > 0) {
            return Beans.omitIllegalBeanTypes(types, baseType).addAll((Type[])additionalTypes).build();
        }
        for (Type type : types) {
            if (!Types.isIllegalBeanType(type)) continue;
            return Beans.omitIllegalBeanTypes(types, baseType).build();
        }
        return types;
    }

    static ImmutableSet.Builder<Type> omitIllegalBeanTypes(Set<Type> types, Object baseType) {
        ImmutableSet.Builder<Type> builder = ImmutableSet.builder();
        for (Type type : types) {
            if (Types.isIllegalBeanType(type)) {
                MetadataLogger.LOG.illegalBeanTypeIgnored(type, baseType);
                continue;
            }
            builder.add(type);
        }
        return builder;
    }

    public static BeanIdentifier getIdentifier(Contextual<?> contextual, ContextualStore contextualStore) {
        return Beans.getIdentifier(contextual, contextualStore, null);
    }

    public static BeanIdentifier getIdentifier(Contextual<?> contextual, ServiceRegistry serviceRegistry) {
        return Beans.getIdentifier(contextual, null, serviceRegistry);
    }

    public static boolean shouldIgnoreFinalMethods(Bean<?> bean) {
        if (bean instanceof AbstractBean) {
            AbstractBean abstractBean = (AbstractBean)bean;
            return abstractBean.isIgnoreFinalMethods();
        }
        return false;
    }

    public static Bean<?> unwrap(Bean<?> bean) {
        if (bean instanceof ForwardingBean) {
            ForwardingBean forwarding = (ForwardingBean)bean;
            return forwarding.delegate();
        }
        return bean;
    }

    private static BeanIdentifier getIdentifier(Contextual<?> contextual, ContextualStore contextualStore, ServiceRegistry serviceRegistry) {
        if (contextual instanceof RIBean) {
            return ((RIBean)contextual).getIdentifier();
        }
        if (contextualStore == null) {
            contextualStore = (ContextualStore)serviceRegistry.get(ContextualStore.class);
        }
        return contextualStore.putIfAbsent(contextual);
    }

    private static class TypeComparator
    implements Comparator<Type>,
    Serializable {
        private static final long serialVersionUID = -2162735176891985078L;
        private static final TypeComparator INSTANCE = new TypeComparator();

        private TypeComparator() {
        }

        @Override
        public int compare(Type o1, Type o2) {
            return Beans.createTypeId(o1).compareTo(Beans.createTypeId(o2));
        }
    }
}

