package org.jboss.weld.logging;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import org.jboss.weld.exceptions.UnserializableDependencyException;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.weld.exceptions.InconsistentSpecializationException;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class ValidatorLogger_$logger extends DelegatingBasicLogger implements ValidatorLogger, org.jboss.weld.logging.WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ValidatorLogger_$logger.class.getName();
    public ValidatorLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String beanSpecializedTooManyTimes$str() {
        return "WELD-001401: Two beans cannot specialize the same bean {0}";
    }
    @Override
    public final InconsistentSpecializationException beanSpecializedTooManyTimes(final Object param1) {
        final InconsistentSpecializationException result = new InconsistentSpecializationException(_formatMessage(beanSpecializedTooManyTimes$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String passivatingBeanWithNonserializableInterceptor$str() {
        return "WELD-001402: The bean {0} declares a passivating scope but has a non-serializable interceptor {1}";
    }
    @Override
    public final DeploymentException passivatingBeanWithNonserializableInterceptor(final Object param1, final Object param2) {
        final DeploymentException result = new DeploymentException(_formatMessage(passivatingBeanWithNonserializableInterceptor$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String passivatingBeanWithNonserializableDecorator$str() {
        return "WELD-001403: The bean {0} declares a passivating scope but has a non-serializable decorator {1}";
    }
    @Override
    public final UnserializableDependencyException passivatingBeanWithNonserializableDecorator(final Object param1, final Object param2) {
        final UnserializableDependencyException result = new UnserializableDependencyException(_formatMessage(passivatingBeanWithNonserializableDecorator$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String newWithQualifiers$str() {
        return "WELD-001404: The injection point is annotated with @New which cannot be combined with other qualifiers: {0}\n\tat {1}\n  StackTrace";
    }
    @Override
    public final DefinitionException newWithQualifiers(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(newWithQualifiers$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String injectionIntoNonBean$str() {
        return "WELD-001405: Cannot inject {0} in a class which is not a bean\n\tat {1}\n  StackTrace";
    }
    @Override
    public final DefinitionException injectionIntoNonBean(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(injectionIntoNonBean$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String injectionIntoNonDependentBean$str() {
        return "WELD-001406: Cannot inject injection point metadata in a non @Dependent scoped bean: {0}\n\tat {1}\n  StackTrace";
    }
    @Override
    public final DefinitionException injectionIntoNonDependentBean(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(injectionIntoNonDependentBean$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String injectionPointWithTypeVariable$str() {
        return "WELD-001407: Cannot declare an injection point with a type variable: {0}\n\tat {1}\n  StackTrace";
    }
    @Override
    public final DefinitionException injectionPointWithTypeVariable(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(injectionPointWithTypeVariable$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String injectionPointHasUnsatisfiedDependencies$str() {
        return "WELD-001408: Unsatisfied dependencies for type {2} with qualifiers {1}\n  at injection point {0}\n  at {3}\n{4}";
    }
    @Override
    public final DeploymentException injectionPointHasUnsatisfiedDependencies(final Object param1, final Object param2, final Object param3, final Object param4, final Object param5) {
        final DeploymentException result = new DeploymentException(_formatMessage(injectionPointHasUnsatisfiedDependencies$str(), param1, param2, param3, param4, param5));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String injectionPointHasAmbiguousDependencies$str() {
        return "WELD-001409: Ambiguous dependencies for type {2} with qualifiers {1}\n  at injection point {0}\n  at {3}\n  Possible dependencies: {4}\n";
    }
    @Override
    public final DeploymentException injectionPointHasAmbiguousDependencies(final Object param1, final Object param2, final Object param3, final Object param4, final Object param5) {
        final DeploymentException result = new DeploymentException(_formatMessage(injectionPointHasAmbiguousDependencies$str(), param1, param2, param3, param4, param5));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String injectionPointHasNonProxyableDependencies$str() {
        return "WELD-001410: The injection point has non-proxyable dependencies: {0}\n\tat {1}\n  StackTrace";
    }
    @Override
    public final DeploymentException injectionPointHasNonProxyableDependencies(final Object param1, final Object stackElement, final Throwable cause) {
        final DeploymentException result = new DeploymentException(_formatMessage(injectionPointHasNonProxyableDependencies$str(), param1, stackElement), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String injectionPointHasNonSerializableDependency$str() {
        return "WELD-001413: The bean {0} declares a passivating scope but has a non-passivation-capable dependency {1}";
    }
    @Override
    public final UnserializableDependencyException injectionPointHasNonSerializableDependency(final Object param1, final Object param2) {
        final UnserializableDependencyException result = new UnserializableDependencyException(_formatMessage(injectionPointHasNonSerializableDependency$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ambiguousElName$str() {
        return "WELD-001414: Bean name is ambiguous. Name {0} resolves to beans: {1}";
    }
    @Override
    public final DeploymentException ambiguousElName(final Object param1, final Object param2) {
        final DeploymentException result = new DeploymentException(_formatMessage(ambiguousElName$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanNameIsPrefix$str() {
        return "WELD-001415: Bean name is identical to a bean name prefix used elsewhere. Name {0}";
    }
    @Override
    public final DeploymentException beanNameIsPrefix(final Object param1) {
        final DeploymentException result = new DeploymentException(_formatMessage(beanNameIsPrefix$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorSpecifiedTwice$str() {
        return "WELD-001416: Enabled interceptor class {0} specified twice:\n  - {1},\n  - {2}";
    }
    @Override
    public final DeploymentException interceptorSpecifiedTwice(final Object param1, final Object param2, final Object param3) {
        final DeploymentException result = new DeploymentException(_formatMessage(interceptorSpecifiedTwice$str(), param1, param2, param3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorClassDoesNotMatchInterceptorBean$str() {
        return "WELD-001417: Enabled interceptor class {0} ({1}) does not match an interceptor bean: the class is not found, or not annotated with @Interceptor and still not registered through a portable extension, or not annotated with @Dependent inside an implicit bean archive";
    }
    @Override
    public final DeploymentException interceptorClassDoesNotMatchInterceptorBean(final Object value, final Object location) {
        final DeploymentException result = new DeploymentException(_formatMessage(interceptorClassDoesNotMatchInterceptorBean$str(), value, location));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String decoratorSpecifiedTwice$str() {
        return "WELD-001418: Enabled decorator class {0} specified twice:\n  - {1},\n  - {2}";
    }
    @Override
    public final DeploymentException decoratorSpecifiedTwice(final Object param1, final Object param2, final Object param3) {
        final DeploymentException result = new DeploymentException(_formatMessage(decoratorSpecifiedTwice$str(), param1, param2, param3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String decoratorClassNotBeanClassOfDecorator$str() {
        return "WELD-001419: Enabled decorator class {0} is not the bean class of at least one decorator bean (detected decorator beans: {1})";
    }
    @Override
    public final DeploymentException decoratorClassNotBeanClassOfDecorator(final Object param1, final Object param2) {
        final DeploymentException result = new DeploymentException(_formatMessage(decoratorClassNotBeanClassOfDecorator$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String alternativeStereotypeNotStereotype$str() {
        return "WELD-001420: Enabled alternative {0} is not a stereotype";
    }
    @Override
    public final DeploymentException alternativeStereotypeNotStereotype(final Object param1) {
        final DeploymentException result = new DeploymentException(_formatMessage(alternativeStereotypeNotStereotype$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String alternativeStereotypeSpecifiedMultipleTimes$str() {
        return "WELD-001421: Cannot enable the same alternative stereotype {0} in beans.xml:\n  - {1},\n  - {2}";
    }
    @Override
    public final DeploymentException alternativeStereotypeSpecifiedMultipleTimes(final Object param1, final Object param2, final Object param3) {
        final DeploymentException result = new DeploymentException(_formatMessage(alternativeStereotypeSpecifiedMultipleTimes$str(), param1, param2, param3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String alternativeBeanClassNotAnnotated$str() {
        return "WELD-001422: Enabled alternative class {0} ({1}) does not match any bean, or is not annotated with @Alternative or an @Alternative stereotype, or does not declare a producer annotated with @Alternative or an @Alternative stereotype";
    }
    @Override
    public final DeploymentException alternativeBeanClassNotAnnotated(final Object value, final Object location) {
        final DeploymentException result = new DeploymentException(_formatMessage(alternativeBeanClassNotAnnotated$str(), value, location));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String disposalMethodsWithoutProducer$str() {
        return "WELD-001424: The following disposal methods were declared but did not resolve to a producer method: {0}";
    }
    @Override
    public final DefinitionException disposalMethodsWithoutProducer(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(disposalMethodsWithoutProducer$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String injectionPointHasWildcard$str() {
        return "WELD-001425: An injection point cannot have a wildcard type parameter: {0}\n\tat {1}\n  StackTrace";
    }
    @Override
    public final DefinitionException injectionPointHasWildcard(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(injectionPointHasWildcard$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String injectionPointMustHaveTypeParameter$str() {
        return "WELD-001426: An injection point must have a type parameter: {0}\n\tat {1}\n  StackTrace";
    }
    @Override
    public final DefinitionException injectionPointMustHaveTypeParameter(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(injectionPointMustHaveTypeParameter$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nonFieldInjectionPointCannotUseNamed$str() {
        return "WELD-001427: Only field injection points can use the @Named qualifier with no value: {0}\n\tat {1}\n  StackTrace";
    }
    @Override
    public final DefinitionException nonFieldInjectionPointCannotUseNamed(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(nonFieldInjectionPointCannotUseNamed$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String decoratorsCannotHaveProducerMethods$str() {
        return "WELD-001428: A decorator cannot have producer methods, but at least one was found on {0}.";
    }
    @Override
    public final DefinitionException decoratorsCannotHaveProducerMethods(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(decoratorsCannotHaveProducerMethods$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String decoratorsCannotHaveProducerFields$str() {
        return "WELD-001429: A decorator cannot have producer fields, but at least one was found on {0}.";
    }
    @Override
    public final DefinitionException decoratorsCannotHaveProducerFields(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(decoratorsCannotHaveProducerFields$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String decoratorsCannotHaveDisposerMethods$str() {
        return "WELD-001430: A decorator cannot have disposer methods, but at least one was found on {0}.";
    }
    @Override
    public final DefinitionException decoratorsCannotHaveDisposerMethods(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(decoratorsCannotHaveDisposerMethods$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorsCannotHaveProducerMethods$str() {
        return "WELD-001431: An interceptor cannot have producer methods, but at least one was found on {0}.";
    }
    @Override
    public final DefinitionException interceptorsCannotHaveProducerMethods(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(interceptorsCannotHaveProducerMethods$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorsCannotHaveProducerFields$str() {
        return "WELD-001432: An interceptor cannot have producer fields, but at least one was found on {0}.";
    }
    @Override
    public final DefinitionException interceptorsCannotHaveProducerFields(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(interceptorsCannotHaveProducerFields$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorsCannotHaveDisposerMethods$str() {
        return "WELD-001433: An interceptor cannot have disposer methods, but at least one was found on {0}.";
    }
    @Override
    public final DefinitionException interceptorsCannotHaveDisposerMethods(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(interceptorsCannotHaveDisposerMethods$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notProxyableUnknown$str() {
        return "WELD-001434: Normal scoped bean {0} is not proxyable for an unknown reason - {1}.";
    }
    @Override
    public final UnproxyableResolutionException notProxyableUnknown(final Object param1, final Object param2) {
        final UnproxyableResolutionException result = new UnproxyableResolutionException(_formatMessage(notProxyableUnknown$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notProxyableNoConstructor$str() {
        return "WELD-001435: Normal scoped bean {0} is not proxyable because it has no no-args constructor - {1}.";
    }
    @Override
    public final UnproxyableResolutionException notProxyableNoConstructor(final Object param1, final Object param2) {
        final UnproxyableResolutionException result = new UnproxyableResolutionException(_formatMessage(notProxyableNoConstructor$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notProxyablePrivateConstructor$str() {
        return "WELD-001436: Type {0} is not proxyable because it has a private constructor {1} - {2}.";
    }
    @Override
    public final String notProxyablePrivateConstructor(final Object param1, final Object param2, final Object param3) {
        return _formatMessage(notProxyablePrivateConstructor$str(), param1, param2, param3);
    }
    protected String notProxyableFinalType$str() {
        return "WELD-001437: Bean type {0} is not proxyable because it is final - {1}.";
    }
    @Override
    public final UnproxyableResolutionException notProxyableFinalType(final Object param1, final Object param2) {
        final UnproxyableResolutionException result = new UnproxyableResolutionException(_formatMessage(notProxyableFinalType$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notProxyablePrimitive$str() {
        return "WELD-001438: Bean type {0} is not proxyable because it is a primitive - {1}.";
    }
    @Override
    public final UnproxyableResolutionException notProxyablePrimitive(final Object param1, final Object param2) {
        final UnproxyableResolutionException result = new UnproxyableResolutionException(_formatMessage(notProxyablePrimitive$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notProxyableArrayType$str() {
        return "WELD-001439: Bean type {0} is not proxyable because it is an array type - {1}.";
    }
    @Override
    public final UnproxyableResolutionException notProxyableArrayType(final Object param1, final Object param2) {
        final UnproxyableResolutionException result = new UnproxyableResolutionException(_formatMessage(notProxyableArrayType$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void scopeAnnotationOnInjectionPoint(final Object param1, final Object param2, final Object stackElement) {
        super.log.logv(FQCN, WARN, null, scopeAnnotationOnInjectionPoint$str(), param1, param2, stackElement);
    }
    protected String scopeAnnotationOnInjectionPoint$str() {
        return "WELD-001440: Scope type {0} used on injection point {1}\n\tat {2}\n  StackTrace";
    }
    protected String alternativeBeanClassNotClass$str() {
        return "WELD-001441: Enabled alternative {0} is not a class";
    }
    @Override
    public final DeploymentException alternativeBeanClassNotClass(final Object param1) {
        final DeploymentException result = new DeploymentException(_formatMessage(alternativeBeanClassNotClass$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String alternativeStereotypeNotAnnotated$str() {
        return "WELD-001442: Enabled alternative {0} is not annotated @Alternative";
    }
    @Override
    public final DeploymentException alternativeStereotypeNotAnnotated(final Object param1) {
        final DeploymentException result = new DeploymentException(_formatMessage(alternativeStereotypeNotAnnotated$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pseudoScopedBeanHasCircularReferences$str() {
        return "WELD-001443: Pseudo scoped bean has circular dependencies. Dependency path: {0}";
    }
    @Override
    public final DeploymentException pseudoScopedBeanHasCircularReferences(final Object param1) {
        final DeploymentException result = new DeploymentException(_formatMessage(pseudoScopedBeanHasCircularReferences$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorsCannotHaveObserverMethods$str() {
        return "WELD-001445: An interceptor cannot have observer methods, but at least one was found on {0}.";
    }
    @Override
    public final DefinitionException interceptorsCannotHaveObserverMethods(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(interceptorsCannotHaveObserverMethods$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String decoratorsCannotHaveObserverMethods$str() {
        return "WELD-001446: A decorator cannot have observer methods, but at least one was found on {0}.";
    }
    @Override
    public final DefinitionException decoratorsCannotHaveObserverMethods(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(decoratorsCannotHaveObserverMethods$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorMethodDoesNotReturnObject$str() {
        return "WELD-001447: Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not return {3}\n\tat {4}\n  StackTrace";
    }
    @Override
    public final DefinitionException interceptorMethodDoesNotReturnObject(final Object param1, final Object param2, final Object param3, final Object param4, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(interceptorMethodDoesNotReturnObject$str(), param1, param2, param3, param4, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorMethodDoesNotHaveExactlyOneParameter$str() {
        return "WELD-001448: Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not have exactly one parameter\n\tat {3}\n  StackTrace";
    }
    @Override
    public final DefinitionException interceptorMethodDoesNotHaveExactlyOneParameter(final Object param1, final Object param2, final Object param3, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(interceptorMethodDoesNotHaveExactlyOneParameter$str(), param1, param2, param3, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorMethodDoesNotHaveCorrectTypeOfParameter$str() {
        return "WELD-001449: Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but its single parameter is not a {3}\n\tat {4}\n  StackTrace";
    }
    @Override
    public final DefinitionException interceptorMethodDoesNotHaveCorrectTypeOfParameter(final Object param1, final Object param2, final Object param3, final Object param4, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(interceptorMethodDoesNotHaveCorrectTypeOfParameter$str(), param1, param2, param3, param4, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userTransactionInjectionIntoBeanWithContainerManagedTransactions$str() {
        return "WELD-001451: jakarta.transaction.UserTransaction cannot be injected into an enterprise bean with container-managed transactions: {0}\n\tat {1}\n  StackTrace";
    }
    @Override
    public final DefinitionException userTransactionInjectionIntoBeanWithContainerManagedTransactions(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(userTransactionInjectionIntoBeanWithContainerManagedTransactions$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBeanMetadataInjectionPointType$str() {
        return "WELD-001452: {0} is not a valid type for a Bean metadata injection point {1}\n\tat {2}\n  StackTrace";
    }
    @Override
    public final DefinitionException invalidBeanMetadataInjectionPointType(final Object param1, final Object param2, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(invalidBeanMetadataInjectionPointType$str(), param1, param2, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBeanMetadataInjectionPointTypeArgument$str() {
        return "WELD-001453: {0} is not a valid type argument for a Bean metadata injection point {1}\n\tat {2}\n  StackTrace";
    }
    @Override
    public final DefinitionException invalidBeanMetadataInjectionPointTypeArgument(final Object param1, final Object param2, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(invalidBeanMetadataInjectionPointTypeArgument$str(), param1, param2, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBeanMetadataInjectionPointQualifier$str() {
        return "WELD-001454: {0} cannot be used at a Bean metadata injection point of a bean which is not {1}, {2}\n\tat {3}\n  StackTrace";
    }
    @Override
    public final DefinitionException invalidBeanMetadataInjectionPointQualifier(final Object param1, final Object param2, final Object param3, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(invalidBeanMetadataInjectionPointQualifier$str(), param1, param2, param3, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDecoratedTypes$str() {
        return "WELD-001455: {0} does not declare any decorated types.";
    }
    @Override
    public final DefinitionException noDecoratedTypes(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(noDecoratedTypes$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String argumentNull1$str() {
        return "WELD-001456: Argument {0} must not be null";
    }
    @Override
    public final IllegalArgumentException argumentNull(final Object param1) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(argumentNull1$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String alternativeClassSpecifiedMultipleTimes$str() {
        return "WELD-001457: Cannot enable the same alternative class {0} in beans.xml:\n  - {1},\n  - {2}";
    }
    @Override
    public final DeploymentException alternativeClassSpecifiedMultipleTimes(final Object param1, final Object param2, final Object param3) {
        final DeploymentException result = new DeploymentException(_formatMessage(alternativeClassSpecifiedMultipleTimes$str(), param1, param2, param3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String beanWithPassivatingScopeNotPassivationCapable$str() {
        return "WELD-001463: Bean declaring a passivating scope must be passivation capable.  Bean:  {0}";
    }
    @Override
    public final DeploymentException beanWithPassivatingScopeNotPassivationCapable(final Object param1) {
        final DeploymentException result = new DeploymentException(_formatMessage(beanWithPassivatingScopeNotPassivationCapable$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String builtinBeanWithNonserializableDecorator$str() {
        return "WELD-001465: {0} for a built-in bean {1} must be passivation capable.";
    }
    @Override
    public final UnserializableDependencyException builtinBeanWithNonserializableDecorator(final Object param1, final Object param2) {
        final UnserializableDependencyException result = new UnserializableDependencyException(_formatMessage(builtinBeanWithNonserializableDecorator$str(), param1, param2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String injectionIntoDisposerMethod$str() {
        return "WELD-001466: Invalid injection point found in a disposer method: {0}\n\tat {1}\n  StackTrace";
    }
    @Override
    public final DefinitionException injectionIntoDisposerMethod(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(injectionIntoDisposerMethod$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorMethodDoesNotReturnObjectOrVoid$str() {
        return "WELD-001467: Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not return {3} or {4}.\n\tat {5}\n  StackTrace";
    }
    @Override
    public final DefinitionException interceptorMethodDoesNotReturnObjectOrVoid(final Object param1, final Object param2, final Object param3, final Object param4, final Object param5, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(interceptorMethodDoesNotReturnObjectOrVoid$str(), param1, param2, param3, param4, param5, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorMethodDoesNotHaveVoidReturnType$str() {
        return "WELD-001468: Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not have a {3} return type.\n\tat {4}\n  StackTrace";
    }
    @Override
    public final DefinitionException interceptorMethodDoesNotHaveVoidReturnType(final Object param1, final Object param2, final Object param3, final Object param4, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(interceptorMethodDoesNotHaveVoidReturnType$str(), param1, param2, param3, param4, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void interceptorMethodDoesNotHaveZeroParameters(final Object param1, final Object param2, final Object param3) {
        super.log.logv(FQCN, WARN, null, interceptorMethodDoesNotHaveZeroParameters$str(), param1, param2, param3);
    }
    protected String interceptorMethodDoesNotHaveZeroParameters$str() {
        return "WELD-001469: Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} but it does not have zero parameters.\n";
    }
    @Override
    public final void interceptorMethodShouldNotThrowCheckedExceptions(final Object param1, final Object param2, final Object param3, final Object stackElement) {
        super.log.logv(FQCN, WARN, null, interceptorMethodShouldNotThrowCheckedExceptions$str(), param1, param2, param3, stackElement);
    }
    protected String interceptorMethodShouldNotThrowCheckedExceptions$str() {
        return "WELD-001471: Interceptor method {0} defined on class {1} is not defined according to the specification. It should not throw {2}, which is a checked exception.\n\tat {3}\n  StackTrace";
    }
    protected String eventMetadataInjectedOutsideOfObserver$str() {
        return "WELD-001472: EventMetadata can only be injected into an observer method: {0}\n\tat {1}\n  StackTrace";
    }
    @Override
    public final DefinitionException eventMetadataInjectedOutsideOfObserver(final Object param1, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(eventMetadataInjectedOutsideOfObserver$str(), param1, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void beanNotPassivationCapable(final Object param1) {
        super.log.logv(FQCN, WARN, null, beanNotPassivationCapable$str(), param1);
    }
    protected String beanNotPassivationCapable$str() {
        return "WELD-001473: jakarta.enterprise.inject.spi.Bean implementation {0} declared a normal scope but does not implementjakarta.enterprise.inject.spi.PassivationCapable. It won'''t be possible to inject this bean into a bean with a passivating scope (@SessionScoped, @ConversationScoped). This can be fixed by assigning the Bean implementation a unique id by implementing the PassivationCapable interface.";
    }
    protected String unsatisfiedDependencyBecauseClassIgnored$str() {
        return "WELD-001474: Class {0} is on the classpath, but was ignored because a class it references was not found: {1}.\n";
    }
    @Override
    public final String unsatisfiedDependencyBecauseClassIgnored(final Object param1, final Object param2) {
        return _formatMessage(unsatisfiedDependencyBecauseClassIgnored$str(), param1, param2);
    }
    protected String unsatisfiedDependencyBecauseQualifiersDontMatch$str() {
        return "WELD-001475: The following beans match by type, but none have matching qualifiers:{0}\n";
    }
    @Override
    public final String unsatisfiedDependencyBecauseQualifiersDontMatch(final Object param1) {
        return _formatMessage(unsatisfiedDependencyBecauseQualifiersDontMatch$str(), param1);
    }
    protected String interceptorOrDecoratorMustBeDependent$str() {
        return "WELD-001476: {0} must be @Dependent";
    }
    @Override
    public final DefinitionException interceptorOrDecoratorMustBeDependent(final Object param1) {
        final DefinitionException result = new DefinitionException(_formatMessage(interceptorOrDecoratorMustBeDependent$str(), param1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorDecoratorInjectionPointHasNonSerializableDependency$str() {
        return "WELD-001477: The bean {0} declares a passivating scope but has a(n) {1} with a non-passivation-capable dependency {2}";
    }
    @Override
    public final UnserializableDependencyException interceptorDecoratorInjectionPointHasNonSerializableDependency(final Object param1, final Object param2, final Object param3) {
        final UnserializableDependencyException result = new UnserializableDependencyException(_formatMessage(interceptorDecoratorInjectionPointHasNonSerializableDependency$str(), param1, param2, param3));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void interceptorEnabledForApplicationAndBeanArchive(final Object interceptor, final Object beanArchive) {
        super.log.logv(FQCN, WARN, null, interceptorEnabledForApplicationAndBeanArchive$str(), interceptor, beanArchive);
    }
    protected String interceptorEnabledForApplicationAndBeanArchive$str() {
        return "WELD-001478: Interceptor {0} is enabled for the application and for the bean archive {1}. It will only be invoked in the @Priority part of the chain.";
    }
    @Override
    public final void decoratorEnabledForApplicationAndBeanArchive(final Object decorator, final Object beanArchive) {
        super.log.logv(FQCN, WARN, null, decoratorEnabledForApplicationAndBeanArchive$str(), decorator, beanArchive);
    }
    protected String decoratorEnabledForApplicationAndBeanArchive$str() {
        return "WELD-001479: Decorator {0} is enabled for the application and for the bean archive {1}. It will only be invoked in the @Priority part of the chain.";
    }
    protected String notProxyableFinalMethod$str() {
        return "WELD-001480: Bean type {0} is not proxyable because it contains a final method {1} - {2}.";
    }
    @Override
    public final UnproxyableResolutionException notProxyableFinalMethod(final Object beanType, final Method finalMethod, final Object declaringBean) {
        final UnproxyableResolutionException result = new UnproxyableResolutionException(_formatMessage(notProxyableFinalMethod$str(), beanType, finalMethod, declaringBean));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void notProxyableFinalMethodIgnored(final Method invalidMethod, final Object declaringBean) {
        super.log.logv(FQCN, WARN, null, notProxyableFinalMethodIgnored$str(), invalidMethod, declaringBean);
    }
    protected String notProxyableFinalMethodIgnored$str() {
        return "WELD-001481: Final method will be ignored during proxy generation and should never be invoked upon the proxy instance! {0} - {1}.";
    }
    protected String invalidInterceptionFactoryInjectionPoint$str() {
        return "WELD-001482: InterceptionFactory can only be injected in a parameter of a producer method: {0}\n\tat {1}\n  StackTrace";
    }
    @Override
    public final DefinitionException invalidInterceptionFactoryInjectionPoint(final Object injectionPoint, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(invalidInterceptionFactoryInjectionPoint$str(), injectionPoint, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String argumentNull0$str() {
        return "WELD-001483: Argument must not be null";
    }
    @Override
    public final IllegalArgumentException argumentNull() {
        final IllegalArgumentException result = new IllegalArgumentException(argumentNull0$str());
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorMethodDeclaresMultipleParameters$str() {
        return "WELD-001485: Method {0} defined on class {1} is not defined according to the specification. It is annotated with @{2} and it declares more than one parameter.\n\tat {3}\n  StackTrace";
    }
    @Override
    public final DefinitionException interceptorMethodDeclaresMultipleParameters(final Object param1, final Object param2, final Object param3, final Object stackElement) {
        final DefinitionException result = new DefinitionException(_formatMessage(interceptorMethodDeclaresMultipleParameters$str(), param1, param2, param3, stackElement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, catchingDebug$str());
    }
    protected String catchingDebug$str() {
        return "Catching";
    }
}
