/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.BeansClosure;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

public class ProducerMethod<X, T>
extends AbstractProducerBean<X, T, Method> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private static final XLogger xLog = LoggerFactory.loggerFactory().getXLogger(Category.BEAN);
    private MethodInjectionPoint<T, ? super X> method;
    private DisposalMethod<X, ?> disposalMethodBean;
    private ProducerMethod<?, ?> specializedBean;
    private final boolean proxiable;

    public static <X, T> ProducerMethod<X, T> of(WeldMethod<T, ? super X> method, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager, ServiceRegistry services) {
        return new ProducerMethod<X, T>(method, declaringBean, beanManager, services);
    }

    protected ProducerMethod(WeldMethod<T, ? super X> method, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(ProducerMethod.createId(method, declaringBean), declaringBean, beanManager, services);
        this.method = MethodInjectionPoint.of(this, method, beanManager);
        this.initType();
        this.initTypes();
        this.initQualifiers();
        this.initStereotypes();
        this.initProducerMethodInjectableParameters();
        this.proxiable = Proxies.isTypesProxyable(this);
    }

    protected static String createId(WeldMethod<?, ?> method, AbstractClassBean<?> declaringBean) {
        if (declaringBean.getWeldAnnotated().isDiscovered()) {
            StringBuilder sb = new StringBuilder();
            sb.append(ProducerMethod.class.getSimpleName());
            sb.append("-");
            sb.append(declaringBean.getWeldAnnotated().getName());
            sb.append(".");
            sb.append(method.getSignature().toString());
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ProducerMethod.class.getSimpleName());
        sb.append("-");
        sb.append(AnnotatedTypes.createTypeId(declaringBean.getWeldAnnotated()));
        sb.append(".");
        sb.append(AnnotatedTypes.createCallableId(method));
        return sb.toString();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.checkProducerMethod();
            this.initDisposalMethod(environment);
            this.setProducer(new ProducerMethodProducer());
        }
    }

    protected void initProducerMethodInjectableParameters() {
        for (ParameterInjectionPoint<?, ? super X> parameterInjectionPoint : this.method.getWeldParameters()) {
            this.addInjectionPoint(ParameterInjectionPoint.of(this, parameterInjectionPoint, this.beanManager));
        }
    }

    protected void checkProducerMethod() {
        if (this.getWeldAnnotated().getWeldParameters(Observes.class).size() > 0) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Produces", "@Observes");
        }
        if (this.getWeldAnnotated().getWeldParameters(Disposes.class).size() > 0) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Produces", "@Disposes");
        }
        if (this.getDeclaringBean() instanceof SessionBean) {
            boolean methodDeclaredOnTypes = false;
            for (Type type : this.getDeclaringBean().getTypes()) {
                if (!(type instanceof Class) || !SecureReflections.isMethodExists((Class)type, this.getWeldAnnotated().getName(), this.getWeldAnnotated().getParameterTypesAsArray())) continue;
                methodDeclaredOnTypes = true;
            }
            if (!methodDeclaredOnTypes) {
                throw new DefinitionException(BeanMessage.METHOD_NOT_BUSINESS_METHOD, this, this.getDeclaringBean());
            }
        }
    }

    protected void initDisposalMethod(BeanDeployerEnvironment environment) {
        Set disposalBeans = environment.resolveDisposalBeans(this.getTypes(), this.getQualifiers(), this.getDeclaringBean());
        if (disposalBeans.size() == 1) {
            this.disposalMethodBean = disposalBeans.iterator().next();
        } else if (disposalBeans.size() > 1) {
            throw new DefinitionException(BeanMessage.MULTIPLE_DISPOSAL_METHODS, this, disposalBeans);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            this.getProducer().dispose(instance);
        }
        catch (Exception e) {
            log.error((Enum)BeanMessage.ERROR_DESTROYING, new Object[]{instance, this});
            xLog.throwing(XLogger.Level.DEBUG, (Throwable)e);
        }
        finally {
            if (this.getDeclaringBean().isDependent()) {
                creationalContext.release();
            }
        }
    }

    @Override
    public WeldMethod<T, ? super X> getWeldAnnotated() {
        return this.method;
    }

    @Override
    protected String getDefaultName() {
        return this.method.getPropertyName();
    }

    public DisposalMethod<X, ?> getDisposalMethod() {
        return this.disposalMethodBean;
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        if (this.getDeclaringBean().getWeldAnnotated().getWeldSuperclass().getDeclaredWeldMethod(this.getWeldAnnotated().getJavaMember()) == null) {
            throw new DefinitionException(BeanMessage.PRODUCER_METHOD_NOT_SPECIALIZING, this);
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        WeldMethod<?, ?> superClassMethod;
        BeansClosure closure = this.beanManager.getClosure();
        ProducerMethod<?, ?> check = closure.getProducerMethod(superClassMethod = this.getDeclaringBean().getWeldAnnotated().getWeldSuperclass().getWeldMethod(this.getWeldAnnotated().getJavaMember()));
        if (check == null) {
            throw new IllegalStateException(BeanMessage.PRODUCER_METHOD_NOT_SPECIALIZING, this);
        }
        this.specializedBean = check;
    }

    @Override
    public String toString() {
        return "Producer Method [" + Formats.formatType(this.getWeldAnnotated().getBaseType()) + "] with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "] declared as [" + this.getWeldAnnotated() + "]";
    }

    @Override
    public boolean isProxyable() {
        return this.proxiable;
    }

    @Override
    public boolean hasDefaultProducer() {
        return this.getProducer() instanceof ProducerMethodProducer;
    }

    private class ProducerMethodProducer
    extends AbstractProducerBean.AbstractProducer {
        private ProducerMethodProducer() {
        }

        public void dispose(T instance) {
            if (ProducerMethod.this.disposalMethodBean != null) {
                ProducerMethod.this.disposalMethodBean.invokeDisposeMethod(instance);
            }
        }

        @Override
        public Set<InjectionPoint> getInjectionPoints() {
            return (Set)Reflections.cast(ProducerMethod.this.getWeldInjectionPoints());
        }

        @Override
        public T produce(Object receiver, CreationalContext<T> creationalContext) {
            if (receiver != null) {
                return ProducerMethod.this.method.invokeOnInstance(receiver, ProducerMethod.this.beanManager, creationalContext, CreationException.class);
            }
            return ProducerMethod.this.method.invoke(null, ProducerMethod.this.beanManager, creationalContext, CreationException.class);
        }

        public String toString() {
            return ProducerMethod.this.method.toString();
        }
    }
}

