/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.files;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.GraphRule;
import org.jboss.windup.config.PreRulesetEvaluation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.files.FileMappingFrom;
import org.jboss.windup.rules.files.FileMappingTo;
import org.jboss.windup.rules.files.FileMappingWithID;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class FileMapping
extends GraphRule
implements PreRulesetEvaluation,
FileMappingFrom,
FileMappingTo,
FileMappingWithID {
    private static final Logger LOG = Logging.get(FileMapping.class);
    private final Pattern pattern;
    private final List<Class<? extends WindupVertexFrame>> types = new ArrayList<Class<? extends WindupVertexFrame>>();
    private FileModel.OnParseError onParseError = FileModel.OnParseError.WARN;
    private String id;

    private FileMapping(Pattern pattern) {
        this.pattern = pattern;
        String normalizedPattern = StringUtils.replacePattern((String)pattern.pattern(), (String)"\\s", (String)"_");
        normalizedPattern = StringUtils.substring((String)normalizedPattern, (int)0, (int)10);
        this.id = this.getClass().getSimpleName() + "_" + normalizedPattern + "_" + RandomStringUtils.randomAlphanumeric((int)2);
    }

    @Override
    public FileMappingWithID withId(String ruleID) {
        this.id = ruleID;
        return this;
    }

    public static FileMappingFrom from(String regex) {
        return new FileMapping(Pattern.compile(regex));
    }

    @Override
    public FileMappingTo to(Class<? extends WindupVertexFrame> type) {
        Assert.notNull(type, (String)"Model type must not be null.");
        this.types.add(type);
        return this;
    }

    @Override
    public FileMappingTo to(Class<? extends WindupVertexFrame> ... types) {
        Assert.notNull(types, (String)"Model type list must not be null.");
        this.types.addAll(Arrays.asList(types));
        return this;
    }

    @Override
    public FileMappingTo onParseError(FileModel.OnParseError onParseError) {
        this.onParseError = onParseError;
        return this;
    }

    public void preRulesetEvaluation(GraphRewrite event) {
        LOG.info("Added " + this.toString());
        for (Class<? extends WindupVertexFrame> type : this.types) {
            FileMapping.addMapping(event, this.pattern.pattern(), type);
        }
        Map<String, List<Class<? extends WindupVertexFrame>>> mappings = FileMapping.getMappings(event);
        FileService fileService = new FileService(event.getGraphContext());
        for (Map.Entry<String, List<Class<? extends WindupVertexFrame>>> entry : mappings.entrySet()) {
            String pattern = entry.getKey();
            List<Class<? extends WindupVertexFrame>> types = entry.getValue();
            Iterable models = fileService.findAllByPropertyMatchingRegex("filePath", new String[]{pattern});
            for (FileModel model : models) {
                if (model.isDirectory()) continue;
                for (Class<? extends WindupVertexFrame> type : types) {
                    GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)model, type);
                }
                if (this.onParseError == FileModel.OnParseError.IGNORE) {
                    model.setOnParseError(FileModel.OnParseError.IGNORE);
                }
                LOG.info("Mapped file [" + model.getFilePath() + "] matching pattern [" + pattern + "] to the following [" + types.size() + "] types: " + types);
            }
        }
    }

    public static Map<String, List<Class<? extends WindupVertexFrame>>> getMappings(GraphRewrite event) {
        HashMap map = (HashMap)event.getRewriteContext().get(FileMapping.class);
        if (map == null) {
            map = new HashMap();
            event.getRewriteContext().put(FileMapping.class, map);
        }
        return map;
    }

    public static List<Class<? extends WindupVertexFrame>> getMappings(GraphRewrite event, String pattern) {
        Map<String, List<Class<? extends WindupVertexFrame>>> mappings = FileMapping.getMappings(event);
        List<Class<? extends WindupVertexFrame>> result = mappings.get(pattern);
        if (result == null) {
            result = new ArrayList<Class<? extends WindupVertexFrame>>();
            mappings.put(pattern, result);
        }
        return result;
    }

    public static void addMapping(GraphRewrite event, String pattern, Class<? extends WindupVertexFrame> type) {
        FileMapping.getMappings(event, pattern).add(type);
    }

    public boolean evaluate(GraphRewrite event, EvaluationContext context) {
        return true;
    }

    public void perform(GraphRewrite event, EvaluationContext context) {
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append(".from(").append(this.pattern).append(")");
        builder.append(".to(").append(this.types).append(")");
        return builder.toString();
    }
}

