/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.files.condition;

import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.rules.files.condition.File;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="file", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class FileHandler
implements ElementHandler<File> {
    public static final String ELEM_NAME = "file";
    private static final String ATTR_FILENAME = "filename";
    private static final String ATTR_FROM = "from";
    private static final Logger LOG = Logging.get(FileHandler.class);

    public File processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String filenamePattern = JOOX.$((Element)element).attr(ATTR_FILENAME);
        String from = JOOX.$((Element)element).attr(ATTR_FROM);
        String as = JOOX.$((Element)element).attr("as");
        if (StringUtils.isBlank((CharSequence)filenamePattern)) {
            throw new WindupException("The 'file' element must have a non-empty 'filename' attribute");
        }
        Object obj = null;
        obj = this.applyFrom(obj, from);
        obj = this.applyFileName(obj, filenamePattern);
        File f = (File)((Object)obj);
        if (as != null) {
            f.as(as);
        }
        return f;
    }

    private Object applyFrom(Object fileContentBuilder, String from) {
        if (from != null) {
            fileContentBuilder = File.from(from);
        }
        return fileContentBuilder;
    }

    private Object applyFileName(Object fileContentBuilder, String fileName) {
        if (fileName != null) {
            if (fileContentBuilder == null) {
                fileContentBuilder = File.inFileNamed(fileName);
            } else {
                File cfr_ignored_0 = (File)((Object)fileContentBuilder);
                fileContentBuilder = File.inFileNamed(fileName);
            }
        }
        return fileContentBuilder;
    }
}

