/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.net.URL;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSNonSpringBusFactory;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSSpringBusFactory;
import org.jboss.wsf.stack.cxf.client.configuration.SecurityActions;
import org.jboss.wsf.stack.cxf.client.util.SpringUtils;

public class JBossWSBusFactory
extends BusFactory {
    private JBossWSSpringBusFactory springBusFactory;
    private JBossWSNonSpringBusFactory nonSpringBusFactory;

    public Bus createBus() {
        if (SpringUtils.isSpringAvailable(new ClassLoader[0])) {
            return this.getSpringBusFactory().createBus();
        }
        return this.getNonSpringBusFactory().createBus();
    }

    public Bus createBus(String cfgFile) {
        return this.getSpringBusFactory().createBus(cfgFile, true);
    }

    public Bus createBus(String[] cfgFiles) {
        return this.getSpringBusFactory().createBus(cfgFiles, true);
    }

    public Bus createBus(String cfgFile, boolean includeDefaults) {
        return this.getSpringBusFactory().createBus(cfgFile, includeDefaults);
    }

    public Bus createBus(String[] cfgFiles, boolean includeDefaults) {
        return this.getSpringBusFactory().createBus(cfgFiles, includeDefaults);
    }

    public Bus createBus(URL url) {
        return this.getSpringBusFactory().createBus(url);
    }

    public Bus createBus(URL[] urls) {
        return this.getSpringBusFactory().createBus(urls);
    }

    public Bus createBus(URL url, boolean includeDefaults) {
        return this.getSpringBusFactory().createBus(url, includeDefaults);
    }

    public Bus createBus(URL[] urls, boolean includeDefaults) {
        return this.getSpringBusFactory().createBus(urls, includeDefaults);
    }

    public Bus createBus(Map<Class, Object> extensions) {
        return this.getNonSpringBusFactory().createBus(extensions);
    }

    public Bus createBus(Map<Class, Object> extensions, Map<String, Object> properties) {
        return this.getNonSpringBusFactory().createBus(extensions, properties);
    }

    public JBossWSSpringBusFactory getSpringBusFactory() {
        if (this.springBusFactory == null) {
            this.springBusFactory = new JBossWSSpringBusFactory();
        }
        return this.springBusFactory;
    }

    public JBossWSNonSpringBusFactory getNonSpringBusFactory() {
        if (this.nonSpringBusFactory == null) {
            this.nonSpringBusFactory = new JBossWSNonSpringBusFactory();
        }
        return this.nonSpringBusFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bus getDefaultBus(ClassLoader contextClassLoader) {
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(contextClassLoader);
            Bus bus = BusFactory.getDefaultBus();
            return bus;
        }
        finally {
            SecurityActions.setContextClassLoader(origClassLoader);
        }
    }
}

