/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.ObjectNameFactory;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;

public class EndpointNameDeploymentAspect
extends AbstractDeploymentAspect {
    private static final ResourceBundle bundle = BundleUtils.getBundle(EndpointNameDeploymentAspect.class);

    @Override
    public void start(Deployment dep) {
        String contextRoot = dep.getService().getContextRoot();
        if (contextRoot == null || !contextRoot.startsWith("/")) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CONTEXT_ROOT_EXPECTED_TO_START_WITH_LEADING_SLASH", (Object[])new Object[]{contextRoot}));
        }
        for (Endpoint ep : dep.getService().getEndpoints()) {
            StringBuilder name = new StringBuilder("jboss.ws:");
            name.append("context=" + contextRoot.substring(1) + ",");
            name.append("endpoint=" + ep.getShortName());
            ep.setName(ObjectNameFactory.create(name.toString()));
        }
    }
}

