/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.sasl;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.xnio.Buffers;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.sasl.SaslQop;

public final class SaslUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];

    private SaslUtils() {
    }

    public static boolean evaluateChallenge(SaslClient client, ByteBuffer destination, ByteBuffer source) throws SaslException {
        byte[] result = client.evaluateChallenge(Buffers.take(source));
        if (result != null) {
            if (destination == null) {
                throw new SaslException("Extra challenge data received");
            }
            destination.put(result);
            return false;
        }
        return true;
    }

    public static boolean evaluateResponse(SaslServer server, ByteBuffer destination, ByteBuffer source) throws SaslException {
        byte[] result = server.evaluateResponse(source.hasRemaining() ? Buffers.take(source) : EMPTY_BYTES);
        if (result != null) {
            if (destination == null) {
                throw new SaslException("Extra response data received");
            }
            destination.put(result);
            return server.isComplete();
        }
        return true;
    }

    public static void wrap(SaslClient client, ByteBuffer destination, ByteBuffer source) throws SaslException {
        byte[] result;
        int len = source.remaining();
        if (len == 0) {
            result = client.wrap(EMPTY_BYTES, 0, len);
        } else if (source.hasArray()) {
            byte[] array = source.array();
            int offs = source.arrayOffset();
            source.position(source.position() + len);
            result = client.wrap(array, offs, len);
        } else {
            result = client.wrap(len == 0 ? EMPTY_BYTES : Buffers.take(source, len), 0, len);
        }
        destination.put(result, 0, result.length);
    }

    public static void wrap(SaslServer server, ByteBuffer destination, ByteBuffer source) throws SaslException {
        byte[] result;
        int len = source.remaining();
        if (len == 0) {
            result = server.wrap(EMPTY_BYTES, 0, len);
        } else if (source.hasArray()) {
            byte[] array = source.array();
            int offs = source.arrayOffset();
            source.position(source.position() + len);
            result = server.wrap(array, offs, len);
        } else {
            result = server.wrap(Buffers.take(source, len), 0, len);
        }
        destination.put(result, 0, result.length);
    }

    public static void unwrap(SaslClient client, ByteBuffer destination, ByteBuffer source) throws SaslException {
        byte[] result;
        int len = source.remaining();
        if (len == 0) {
            result = client.unwrap(EMPTY_BYTES, 0, len);
        } else if (source.hasArray()) {
            byte[] array = source.array();
            int offs = source.arrayOffset();
            source.position(source.position() + len);
            result = client.unwrap(array, offs, len);
        } else {
            result = client.unwrap(Buffers.take(source, len), 0, len);
        }
        destination.put(result, 0, result.length);
    }

    public static void unwrap(SaslServer server, ByteBuffer destination, ByteBuffer source) throws SaslException {
        byte[] result;
        int len = source.remaining();
        if (len == 0) {
            result = server.unwrap(EMPTY_BYTES, 0, len);
        } else if (source.hasArray()) {
            byte[] array = source.array();
            int offs = source.arrayOffset();
            source.position(source.position() + len);
            result = server.unwrap(array, offs, len);
        } else {
            result = server.unwrap(Buffers.take(source, len), 0, len);
        }
        destination.put(result, 0, result.length);
    }

    public static Map<String, Object> createPropertyMap(OptionMap optionMap, boolean secure) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>();
        SaslUtils.add(optionMap, Options.SASL_POLICY_FORWARD_SECRECY, propertyMap, "javax.security.sasl.policy.forward", null);
        SaslUtils.add(optionMap, Options.SASL_POLICY_NOACTIVE, propertyMap, "javax.security.sasl.policy.noactive", null);
        SaslUtils.add(optionMap, Options.SASL_POLICY_NOANONYMOUS, propertyMap, "javax.security.sasl.policy.noanonymous", Boolean.TRUE);
        SaslUtils.add(optionMap, Options.SASL_POLICY_NODICTIONARY, propertyMap, "javax.security.sasl.policy.nodictionary", null);
        SaslUtils.add(optionMap, Options.SASL_POLICY_NOPLAINTEXT, propertyMap, "javax.security.sasl.policy.noplaintext", !secure);
        SaslUtils.add(optionMap, Options.SASL_POLICY_PASS_CREDENTIALS, propertyMap, "javax.security.sasl.policy.credentials", null);
        SaslUtils.add(optionMap, Options.SASL_REUSE, propertyMap, "javax.security.sasl.reuse", null);
        SaslUtils.add(optionMap, Options.SASL_SERVER_AUTH, propertyMap, "javax.security.sasl.server.authentication", null);
        SaslUtils.addQopList(optionMap, Options.SASL_QOP, propertyMap, "javax.security.sasl.qop");
        SaslUtils.add(optionMap, Options.SASL_STRENGTH, propertyMap, "javax.security.sasl.strength", null);
        return propertyMap;
    }

    private static <T> void add(OptionMap optionMap, Option<T> option, Map<String, Object> map, String propName, T defaultVal) {
        T value = optionMap.get(option, defaultVal);
        if (value != null) {
            map.put(propName, value.toString().toLowerCase(Locale.US));
        }
    }

    private static void addQopList(OptionMap optionMap, Option<Sequence<SaslQop>> option, Map<String, Object> map, String propName) {
        Sequence<SaslQop> value = optionMap.get(option);
        if (value == null) {
            return;
        }
        Sequence<SaslQop> seq = value;
        StringBuilder builder = new StringBuilder();
        Iterator<SaslQop> iterator = seq.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        do {
            builder.append(iterator.next().getString());
            if (!iterator.hasNext()) continue;
            builder.append(',');
        } while (iterator.hasNext());
        map.put(propName, builder.toString());
    }
}

