/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.repository.storage;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jbpm.process.workitem.repository.RepositoryStorage;
import org.jbpm.process.workitem.repository.service.RepoData;

public class InMemoryRepositoryStorage<T>
implements RepositoryStorage<T> {
    protected List<RepoData> services;

    @Override
    public List<RepoData> synchronizeServices(List<RepoData> currentServices) {
        this.services = currentServices;
        this.services.forEach(service -> this.enforceId((RepoData)service));
        return this.services;
    }

    @Override
    public List<RepoData> loadServices(int start, int offset) {
        return this.services.stream().skip(start).limit(offset).collect(Collectors.toList());
    }

    @Override
    public List<RepoData> loadServices(Predicate<RepoData> predicate, int start, int offset) {
        return this.services.stream().filter(predicate).skip(start).limit(offset).collect(Collectors.toList());
    }

    @Override
    public void onAdded(RepoData service) {
    }

    @Override
    public void onEnabled(RepoData service) {
    }

    @Override
    public void onDisabled(RepoData service) {
    }

    @Override
    public void onInstalled(RepoData service, String target) {
    }

    @Override
    public void onUninstalled(RepoData service, String target) {
    }

    protected void enforceId(RepoData service) {
        if (service.getId() == null) {
            try {
                service.setId(UUID.nameUUIDFromBytes(service.getName().getBytes("UTF-8")).toString());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    @Override
    public T loadConfiguration() {
        return null;
    }

    @Override
    public void storeConfiguration(T configuration) {
    }
}

