/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.strategy;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.process.audit.strategy.KieSessionCommandScopedStrategy;
import org.jbpm.process.audit.strategy.PersistenceStrategy;
import org.jbpm.process.audit.strategy.SpringStandaloneJtaSharedEntityManagerStrategy;
import org.jbpm.process.audit.strategy.SpringStandaloneLocalSharedEntityManagerStrategy;
import org.jbpm.process.audit.strategy.StandaloneJtaStrategy;
import org.jbpm.process.audit.strategy.StandaloneLocalStrategy;
import org.kie.api.runtime.Environment;

public enum PersistenceStrategyType {
    KIE_SESSION,
    STANDALONE_JTA,
    STANDALONE_JTA_SPRING_SHARED_EM,
    STANDALONE_LOCAL_SPRING_SHARED_EM,
    STANDALONE_LOCAL;


    public static PersistenceStrategy getPersistenceStrategy(PersistenceStrategyType type, Environment env) {
        return PersistenceStrategyType.getPersistenceStrategy(type, env, null, null);
    }

    public static PersistenceStrategy getPersistenceStrategy(PersistenceStrategyType type, EntityManagerFactory emf) {
        return PersistenceStrategyType.getPersistenceStrategy(type, null, emf, null);
    }

    public static PersistenceStrategy getPersistenceStrategy(PersistenceStrategyType type, String peristenceUnitName) {
        return PersistenceStrategyType.getPersistenceStrategy(type, null, null, peristenceUnitName);
    }

    public static PersistenceStrategy getPersistenceStrategy(PersistenceStrategyType type, Environment env, EntityManagerFactory emf, String persistenceUnitName) {
        PersistenceStrategy persistenceStrategy;
        if (env != null) {
            emf = (EntityManagerFactory)env.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        }
        switch (type) {
            case KIE_SESSION: {
                persistenceStrategy = new KieSessionCommandScopedStrategy(env);
                break;
            }
            case STANDALONE_JTA: {
                if (emf != null) {
                    persistenceStrategy = new StandaloneJtaStrategy(emf);
                    break;
                }
                if (persistenceUnitName != null) {
                    persistenceStrategy = new StandaloneJtaStrategy(Persistence.createEntityManagerFactory((String)persistenceUnitName));
                    break;
                }
                throw new IllegalArgumentException("Either the EnvironmentName.ENTITY_MANAGER_FACTORY should be set in the given Environment, or a valid peristence unit name is required.");
            }
            case STANDALONE_JTA_SPRING_SHARED_EM: {
                if (emf != null) {
                    persistenceStrategy = new SpringStandaloneJtaSharedEntityManagerStrategy(emf);
                    break;
                }
                throw new IllegalArgumentException("The EnvironmentName.ENTITY_MANAGER_FACTORY should be set with a valid EntityManagerFactory instance in the given Environment instance.");
            }
            case STANDALONE_LOCAL_SPRING_SHARED_EM: {
                if (emf != null) {
                    persistenceStrategy = new SpringStandaloneLocalSharedEntityManagerStrategy(emf);
                    break;
                }
                throw new IllegalArgumentException("The EnvironmentName.ENTITY_MANAGER_FACTORY should be set with a valid EntityManagerFactory instance in the given Environment instance.");
            }
            case STANDALONE_LOCAL: {
                if (emf != null) {
                    persistenceStrategy = new StandaloneLocalStrategy(emf);
                    break;
                }
                throw new IllegalArgumentException("This strategy requires a EntityManagerFactory instance!");
            }
            default: {
                throw new IllegalArgumentException("Unknown " + PersistenceStrategyType.class.getSimpleName() + " type: " + (Object)((Object)type));
            }
        }
        return persistenceStrategy;
    }
}

