/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit;

import java.util.List;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.command.AuditNodeInstanceLogQueryCommand;
import org.jbpm.process.audit.command.AuditProcessInstanceLogQueryCommand;
import org.jbpm.process.audit.command.AuditVariableInstanceLogQueryCommand;
import org.jbpm.process.audit.command.ClearHistoryLogsCommand;
import org.jbpm.process.audit.command.FindActiveProcessInstancesCommand;
import org.jbpm.process.audit.command.FindNodeInstancesCommand;
import org.jbpm.process.audit.command.FindProcessInstanceCommand;
import org.jbpm.process.audit.command.FindProcessInstancesCommand;
import org.jbpm.process.audit.command.FindSubProcessInstancesCommand;
import org.jbpm.process.audit.command.FindVariableInstancesByNameCommand;
import org.jbpm.process.audit.command.FindVariableInstancesCommand;
import org.jbpm.process.audit.query.NodeInstLogQueryBuilderImpl;
import org.jbpm.process.audit.query.NodeInstanceLogDeleteBuilderImpl;
import org.jbpm.process.audit.query.ProcInstLogQueryBuilderImpl;
import org.jbpm.process.audit.query.ProcessInstanceLogDeleteBuilderImpl;
import org.jbpm.process.audit.query.VarInstLogQueryBuilderImpl;
import org.jbpm.process.audit.query.VarInstanceLogDeleteBuilderImpl;
import org.jbpm.query.jpa.data.QueryWhere;
import org.kie.api.command.Command;
import org.kie.api.runtime.CommandExecutor;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogQueryBuilder;

public class CommandBasedAuditLogService
implements AuditLogService {
    private CommandExecutor executor;

    public CommandBasedAuditLogService(CommandExecutor executor) {
        this.executor = executor;
    }

    @Override
    public List<ProcessInstanceLog> findProcessInstances() {
        return (List)this.executor.execute((Command)new FindProcessInstancesCommand());
    }

    @Override
    public List<ProcessInstanceLog> findActiveProcessInstances() {
        return (List)this.executor.execute((Command)new FindActiveProcessInstancesCommand());
    }

    @Override
    public List<ProcessInstanceLog> findProcessInstances(String processId) {
        return (List)this.executor.execute((Command)new FindProcessInstancesCommand(processId));
    }

    @Override
    public List<ProcessInstanceLog> findActiveProcessInstances(String processId) {
        return (List)this.executor.execute((Command)new FindActiveProcessInstancesCommand(processId));
    }

    @Override
    public ProcessInstanceLog findProcessInstance(long processInstanceId) {
        return (ProcessInstanceLog)this.executor.execute((Command)new FindProcessInstanceCommand(processInstanceId));
    }

    @Override
    public List<ProcessInstanceLog> findSubProcessInstances(long processInstanceId) {
        return (List)this.executor.execute((Command)new FindSubProcessInstancesCommand(processInstanceId));
    }

    @Override
    public List<NodeInstanceLog> findNodeInstances(long processInstanceId) {
        return (List)this.executor.execute((Command)new FindNodeInstancesCommand(processInstanceId));
    }

    @Override
    public List<NodeInstanceLog> findNodeInstances(long processInstanceId, String nodeId) {
        return (List)this.executor.execute((Command)new FindNodeInstancesCommand(processInstanceId, nodeId));
    }

    @Override
    public List<VariableInstanceLog> findVariableInstances(long processInstanceId) {
        return (List)this.executor.execute((Command)new FindVariableInstancesCommand(processInstanceId));
    }

    @Override
    public List<VariableInstanceLog> findVariableInstances(long processInstanceId, String variableId) {
        return (List)this.executor.execute((Command)new FindVariableInstancesCommand(processInstanceId, variableId));
    }

    @Override
    public List<VariableInstanceLog> findVariableInstancesByName(String variableId, boolean activeProcesses) {
        return (List)this.executor.execute((Command)new FindVariableInstancesByNameCommand(variableId, activeProcesses));
    }

    @Override
    public List<VariableInstanceLog> findVariableInstancesByNameAndValue(String variableId, String value, boolean activeProcesses) {
        return (List)this.executor.execute((Command)new FindVariableInstancesByNameCommand(variableId, value, activeProcesses));
    }

    @Override
    public NodeInstanceLogQueryBuilder nodeInstanceLogQuery() {
        return new NodeInstLogQueryBuilderImpl(this.executor);
    }

    @Override
    public VariableInstanceLogQueryBuilder variableInstanceLogQuery() {
        return new VarInstLogQueryBuilderImpl(this.executor);
    }

    @Override
    public ProcessInstanceLogQueryBuilder processInstanceLogQuery() {
        return new ProcInstLogQueryBuilderImpl(this.executor);
    }

    @Override
    public ProcessInstanceLogDeleteBuilder processInstanceLogDelete() {
        return new ProcessInstanceLogDeleteBuilderImpl(this.executor);
    }

    @Override
    public NodeInstanceLogDeleteBuilder nodeInstanceLogDelete() {
        return new NodeInstanceLogDeleteBuilderImpl(this.executor);
    }

    @Override
    public VariableInstanceLogDeleteBuilder variableInstanceLogDelete() {
        return new VarInstanceLogDeleteBuilderImpl(this.executor);
    }

    @Override
    public <T, R> List<R> queryLogs(QueryWhere queryWhere, Class<T> queryClass, Class<R> resultClass) {
        if (queryClass.equals(NodeInstanceLog.class)) {
            return (List)this.executor.execute((Command)new AuditNodeInstanceLogQueryCommand(queryWhere));
        }
        if (queryClass.equals(ProcessInstanceLog.class)) {
            return (List)this.executor.execute((Command)new AuditProcessInstanceLogQueryCommand(queryWhere));
        }
        if (queryClass.equals(VariableInstanceLog.class)) {
            return (List)this.executor.execute((Command)new AuditVariableInstanceLogQueryCommand(queryWhere));
        }
        String type = queryClass == null ? "null" : queryClass.getName();
        throw new IllegalArgumentException("Unknown type for query:" + type);
    }

    public void clear() {
        this.executor.execute((Command)new ClearHistoryLogsCommand());
    }

    public void dispose() {
    }
}

