/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.cmmn.xml;

import java.util.Map;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.casemgmt.cmmn.core.PlanItem;
import org.jbpm.casemgmt.cmmn.xml.AbstractCaseNodeHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MilestoneHandler
extends AbstractCaseNodeHandler {
    private static final Logger logger = LoggerFactory.getLogger(MilestoneHandler.class);

    @Override
    protected Node createNode(Attributes attrs) {
        return new MilestoneNode();
    }

    @Override
    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        MilestoneNode milestoneNode = (MilestoneNode)node;
        ProcessBuildData buildData = (ProcessBuildData)parser.getData();
        Map planItems = (Map)buildData.getMetaData("PlanItems");
        PlanItem milestonePlanItem = (PlanItem)planItems.get(milestoneNode.getMetaData("UniqueId"));
        if (milestonePlanItem != null && milestonePlanItem.getExitCriterion() != null) {
            milestoneNode.setConstraint(milestonePlanItem.getExitCriterion().getExpression());
        }
    }

    public Class<?> generateNodeFor() {
        return MilestoneNode.class;
    }
}

