/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Collection;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.kie.api.runtime.process.NodeInstance;

public class BoundaryEventNodeInstance
extends EventNodeInstance {
    private static final long serialVersionUID = -4958054074031174180L;

    @Override
    public void signalEvent(String type, Object event) {
        BoundaryEventNode boundaryNode = (BoundaryEventNode)this.getEventNode();
        String attachedTo = boundaryNode.getAttachedToNodeId();
        Collection nodeInstances = ((NodeInstanceContainer)this.getNodeInstanceContainer()).getNodeInstances();
        if (type != null && type.startsWith("Compensation")) {
            if (!this.isAttachedToNodeActive(nodeInstances, attachedTo) && this.isAttachedToNodeCompleted(attachedTo)) {
                super.signalEvent(type, event);
            } else {
                this.cancel();
            }
        } else if (this.isAttachedToNodeActive(nodeInstances, attachedTo)) {
            super.signalEvent(type, event);
        } else {
            this.cancel();
        }
    }

    private boolean isAttachedToNodeActive(Collection<NodeInstance> nodeInstances, String attachedTo) {
        if (nodeInstances != null && !nodeInstances.isEmpty()) {
            for (NodeInstance nInstance : nodeInstances) {
                boolean hasActive;
                String nodeUniqueId = (String)nInstance.getNode().getMetaData().get("UniqueId");
                if (attachedTo.equals(nodeUniqueId)) {
                    return true;
                }
                if (!(nInstance instanceof CompositeNodeInstance) || !(hasActive = this.isAttachedToNodeActive(((CompositeNodeInstance)nInstance).getNodeInstances(), attachedTo))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAttachedToNodeCompleted(String attachedTo) {
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)this.getProcessInstance();
        return processInstance.getCompletedNodeIds().contains(attachedTo);
    }
}

