/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.SessionConfiguration;
import org.drools.core.impl.EnvironmentFactory;
import org.jbpm.process.StatefulProcessSession;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.rule.Query;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.StatelessKnowledgeSession;

public class ProcessBaseImpl
implements KnowledgeBase {
    private Map<String, Process> processes = new HashMap<String, Process>();
    private Map<String, KnowledgePackage> packages = new HashMap<String, KnowledgePackage>();
    private List<KieBaseEventListener> listeners = new ArrayList<KieBaseEventListener>();

    public void addEventListener(KieBaseEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(KieBaseEventListener listener) {
        this.listeners.remove(listener);
    }

    public Collection<KieBaseEventListener> getKieBaseEventListeners() {
        return this.listeners;
    }

    public void addKnowledgePackages(Collection<KnowledgePackage> kpackages) {
        for (KnowledgePackage knowledgePackage : kpackages) {
            this.addPackage(knowledgePackage);
        }
    }

    public void addPackage(KnowledgePackage knowledgePackage) {
        this.packages.put(knowledgePackage.getName(), knowledgePackage);
        for (Process process : knowledgePackage.getProcesses()) {
            this.processes.put(process.getId(), process);
        }
    }

    public Collection<KnowledgePackage> getKnowledgePackages() {
        return this.packages.values();
    }

    public StatefulKnowledgeSession newStatefulKnowledgeSession() {
        return this.newStatefulKnowledgeSession((KieSessionConfiguration)SessionConfiguration.newInstance(), EnvironmentFactory.newEnvironment());
    }

    public KieSession newKieSession() {
        return this.newKieSession((KieSessionConfiguration)SessionConfiguration.newInstance(), EnvironmentFactory.newEnvironment());
    }

    public StatefulKnowledgeSession newStatefulKnowledgeSession(KieSessionConfiguration conf, Environment environment) {
        return new StatefulProcessSession(this, conf, environment);
    }

    public KieSession newKieSession(KieSessionConfiguration conf, Environment environment) {
        return new StatefulProcessSession(this, conf, environment);
    }

    public Collection<StatefulKnowledgeSession> getStatefulKnowledgeSessions() {
        return (Collection)ProcessBaseImpl.unsupported("Stateful sessions are not supported");
    }

    public Collection<StatefulKnowledgeSession> getKieSessions() {
        return (Collection)ProcessBaseImpl.unsupported("Stateful sessions are not supported");
    }

    public StatelessKnowledgeSession newStatelessKnowledgeSession() {
        return (StatelessKnowledgeSession)ProcessBaseImpl.unsupported("Stateless sessions are not supported");
    }

    public StatelessKnowledgeSession newStatelessKieSession() {
        return (StatelessKnowledgeSession)ProcessBaseImpl.unsupported("Stateless sessions are not supported");
    }

    public StatelessKnowledgeSession newStatelessKnowledgeSession(KieSessionConfiguration conf) {
        return (StatelessKnowledgeSession)ProcessBaseImpl.unsupported("Stateless sessions are not supported");
    }

    public StatelessKnowledgeSession newStatelessKieSession(KieSessionConfiguration conf) {
        return (StatelessKnowledgeSession)ProcessBaseImpl.unsupported("Stateless sessions are not supported");
    }

    public void removeKnowledgePackage(String packageName) {
        this.packages.remove(packageName);
    }

    public void removeRule(String packageName, String ruleName) {
        ProcessBaseImpl.unsupported(null);
    }

    public void removeQuery(String packageName, String queryName) {
        ProcessBaseImpl.unsupported(null);
    }

    public void removeFunction(String packageName, String ruleName) {
        ProcessBaseImpl.unsupported(null);
    }

    public void removeProcess(String processId) {
        this.processes.remove(processId);
    }

    public FactType getFactType(String packageName, String typeName) {
        return (FactType)ProcessBaseImpl.unsupported(null);
    }

    public KnowledgePackage getKnowledgePackage(String packageName) {
        return this.packages.get(packageName);
    }

    public Process getProcess(String processId) {
        return this.processes.get(processId);
    }

    public Collection<Process> getProcesses() {
        return this.processes.values();
    }

    public Rule getRule(String packageName, String ruleName) {
        return (Rule)ProcessBaseImpl.unsupported(null);
    }

    public Query getQuery(String packageName, String queryName) {
        return (Query)ProcessBaseImpl.unsupported(null);
    }

    public Set<String> getEntryPointIds() {
        return (Set)ProcessBaseImpl.unsupported("Entry points are not supported");
    }

    public Collection<KiePackage> getKiePackages() {
        ArrayList<KiePackage> kPackages = new ArrayList<KiePackage>(this.packages.size());
        for (KnowledgePackage pkg : this.packages.values()) {
            kPackages.add((KiePackage)pkg);
        }
        return kPackages;
    }

    public KiePackage getKiePackage(String packageName) {
        return this.getKnowledgePackage(packageName);
    }

    public void removeKiePackage(String packageName) {
        this.removeKnowledgePackage(packageName);
    }

    static Object unsupported(String msg) {
        String methodName = new Throwable().getStackTrace()[1].getMethodName();
        StringBuffer errMsg = new StringBuffer(methodName).append(" is not supported on ").append(ProcessBaseImpl.class.getSimpleName());
        if (msg != null) {
            errMsg.append(": ").append(msg);
        }
        throw new UnsupportedOperationException(errMsg.toString());
    }
}

