/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.kie.api.runtime.process.NodeInstance;

public class VariableUtil {
    protected static final Pattern PARAMETER_MATCHER = Pattern.compile("#\\{([\\S&&[^\\}]]+)\\}", 32);

    public static String resolveVariable(String s, NodeInstance nodeInstance) {
        if (s == null) {
            return null;
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        Matcher matcher = PARAMETER_MATCHER.matcher(s);
        while (matcher.find()) {
            VariableScopeInstance variableScopeInstance;
            String paramName = matcher.group(1);
            if (replacements.get(paramName) != null || (variableScopeInstance = (VariableScopeInstance)((org.jbpm.workflow.instance.NodeInstance)nodeInstance).resolveContextInstance("VariableScope", paramName)) == null) continue;
            Object variableValue = variableScopeInstance.getVariable(paramName);
            String variableValueString = variableValue == null ? "" : variableValue.toString();
            replacements.put(paramName, variableValueString);
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
        }
        return s;
    }
}

