/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTransformer;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.BoundaryEventNode;

public class BoundaryEventNodeFactory
extends NodeFactory {
    private NodeContainer nodeContainer;
    private String attachedToUniqueId;

    public BoundaryEventNodeFactory(RuleFlowNodeContainerFactory nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, id);
        this.nodeContainer = nodeContainer;
    }

    public BoundaryEventNodeFactory attachedTo(long attachedToId) {
        this.attachedToUniqueId = (String)this.nodeContainer.getNode(attachedToId).getMetaData().get("UniqueId");
        this.getBoundaryEventNode().setAttachedToNodeId(this.attachedToUniqueId);
        this.getBoundaryEventNode().setMetaData("AttachedTo", this.attachedToUniqueId);
        return this;
    }

    @Override
    protected Node createNode() {
        return new BoundaryEventNode();
    }

    protected BoundaryEventNode getBoundaryEventNode() {
        return (BoundaryEventNode)this.getNode();
    }

    public BoundaryEventNodeFactory name(String name) {
        this.getNode().setName(name);
        return this;
    }

    public BoundaryEventNodeFactory variableName(String variableName) {
        this.getBoundaryEventNode().setVariableName(variableName);
        return this;
    }

    public BoundaryEventNodeFactory eventFilter(EventFilter eventFilter) {
        this.getBoundaryEventNode().addEventFilter(eventFilter);
        return this;
    }

    public BoundaryEventNodeFactory eventType(String eventType) {
        EventTypeFilter filter = new EventTypeFilter();
        filter.setType(eventType);
        return this.eventFilter(filter);
    }

    public BoundaryEventNodeFactory eventType(String eventTypePrefix, String eventTypeSurffix) {
        if (this.attachedToUniqueId == null) {
            throw new IllegalStateException("attachedTo() must be called before");
        }
        EventTypeFilter filter = new EventTypeFilter();
        filter.setType(eventTypePrefix + "-" + this.attachedToUniqueId + "-" + eventTypeSurffix);
        return this.eventFilter(filter);
    }

    public BoundaryEventNodeFactory timeCycle(String timeCycle) {
        this.eventType("Timer", timeCycle);
        this.setMetaData("TimeCycle", timeCycle);
        return this;
    }

    public BoundaryEventNodeFactory timeCycle(String timeCycle, String language) {
        this.eventType("Timer", timeCycle);
        this.setMetaData("TimeCycle", timeCycle);
        this.setMetaData("Language", language);
        return this;
    }

    public BoundaryEventNodeFactory timeDuration(String timeDuration) {
        this.eventType("Timer", timeDuration);
        this.setMetaData("TimeDuration", timeDuration);
        return this;
    }

    public BoundaryEventNodeFactory cancelActivity(boolean cancelActivity) {
        this.setMetaData("CancelActivity", cancelActivity);
        return this;
    }

    public BoundaryEventNodeFactory eventTransformer(EventTransformer transformer) {
        this.getBoundaryEventNode().setEventTransformer(transformer);
        return this;
    }

    public BoundaryEventNodeFactory scope(String scope) {
        this.getBoundaryEventNode().setScope(scope);
        return this;
    }

    public BoundaryEventNodeFactory setMetaData(String name, Object value) {
        this.getBoundaryEventNode().setMetaData(name, value);
        return this;
    }
}

