/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.audit.variable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ServiceLoader;
import org.jbpm.services.task.audit.variable.StringTaskVariableIndexer;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskVariable;
import org.kie.internal.task.api.TaskVariableIndexer;

public class TaskIndexerManager {
    private static ServiceLoader<TaskVariableIndexer> taskVariableIndexers = ServiceLoader.load(TaskVariableIndexer.class);
    private static TaskIndexerManager INSTANCE;
    private List<TaskVariableIndexer> indexers = new ArrayList<TaskVariableIndexer>();

    private TaskIndexerManager() {
        for (TaskVariableIndexer indexer : taskVariableIndexers) {
            this.indexers.add(indexer);
        }
        this.indexers.add(new StringTaskVariableIndexer());
    }

    public List<TaskVariable> index(Task task, String variableName, Object variable) {
        for (TaskVariableIndexer indexer : this.indexers) {
            List indexed;
            if (!indexer.accept(variable) || (indexed = indexer.index(variableName, variable)) == null) continue;
            for (TaskVariable taskVariable : indexed) {
                taskVariable.setTaskId(task.getId());
                taskVariable.setTaskId(task.getId());
                taskVariable.setProcessInstanceId(Long.valueOf(task.getTaskData().getProcessInstanceId()));
                taskVariable.setProcessId(task.getTaskData().getProcessId());
                taskVariable.setModificationDate(new Date());
            }
            return indexed;
        }
        return null;
    }

    public static TaskIndexerManager get() {
        if (INSTANCE == null) {
            INSTANCE = new TaskIndexerManager();
        }
        return INSTANCE;
    }
}

