/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.form.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.kie.services.impl.form.model.ExternalData;
import org.jbpm.kie.services.impl.form.model.FBValidation;
import org.jbpm.kie.services.impl.form.model.InputData;
import org.jbpm.kie.services.impl.form.model.Mappable;
import org.jbpm.kie.services.impl.form.model.OutputData;
import org.jbpm.kie.services.impl.form.model.ScriptRepresentation;
import org.jbpm.kie.services.impl.form.model.forms.FormEncodingException;
import org.jbpm.kie.services.impl.form.model.forms.FormEncodingFactory;
import org.jbpm.kie.services.impl.form.model.forms.FormRepresentationDecoder;

public abstract class FormItemRepresentation
implements Mappable {
    private Map<String, ScriptRepresentation> eventActions = new HashMap<String, ScriptRepresentation>();
    private List<FBValidation> itemValidations = new ArrayList<FBValidation>();
    private OutputData output;
    private InputData input;
    private ExternalData external;
    private String width;
    private String height;
    private final String typeId;
    private List<String> effectClasses = new ArrayList<String>();

    public FormItemRepresentation(String typeId) {
        this.typeId = typeId;
    }

    public void setEventActions(Map<String, ScriptRepresentation> eventActions) {
        this.eventActions = eventActions;
    }

    public Map<String, ScriptRepresentation> getEventActions() {
        return this.eventActions;
    }

    public List<FBValidation> getItemValidations() {
        return this.itemValidations;
    }

    public void setItemValidations(List<FBValidation> itemValidations) {
        this.itemValidations = itemValidations;
    }

    public OutputData getOutput() {
        return this.output;
    }

    public void setOutput(OutputData output) {
        this.output = output;
    }

    public InputData getInput() {
        return this.input;
    }

    public void setInput(InputData input) {
        this.input = input;
    }

    public ExternalData getExternal() {
        return this.external;
    }

    public void setExternal(ExternalData external) {
        this.external = external;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public List<String> getEffectClasses() {
        return this.effectClasses;
    }

    public void setEffectClasses(List<String> effectClasses) {
        this.effectClasses = effectClasses;
    }

    public boolean addEffectClass(Class<?> clazz) {
        return this.effectClasses.add(clazz.getName());
    }

    @Override
    public Map<String, Object> getDataMap() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("@className", this.getClass().getName());
        ArrayList<Map<String, Object>> validationsMap = new ArrayList<Map<String, Object>>();
        if (this.itemValidations != null) {
            for (FBValidation valid : this.itemValidations) {
                Map<String, Object> map = valid.getDataMap();
                validationsMap.add(map);
            }
        }
        data.put("itemValidations", validationsMap);
        data.put("effectClasses", new ArrayList<String>(this.effectClasses));
        data.put("output", this.output == null ? null : this.output.getDataMap());
        data.put("input", this.input == null ? null : this.input.getDataMap());
        data.put("external", this.external == null ? null : this.external.getDataMap());
        data.put("width", this.width);
        data.put("height", this.height);
        data.put("typeId", this.typeId);
        HashMap<String, Map<String, Object>> eventActionsMap = new HashMap<String, Map<String, Object>>();
        if (this.eventActions != null) {
            for (Map.Entry<String, ScriptRepresentation> entry : this.eventActions.entrySet()) {
                ScriptRepresentation script = entry.getValue();
                if (script != null) {
                    Map<String, Object> scriptMap = script.getDataMap();
                    eventActionsMap.put(entry.getKey(), scriptMap);
                    continue;
                }
                eventActionsMap.put(entry.getKey(), null);
            }
        }
        data.put("eventActions", eventActionsMap);
        return data;
    }

    @Override
    public void setDataMap(Map<String, Object> data) throws FormEncodingException {
        FormRepresentationDecoder decoder = FormEncodingFactory.getDecoder();
        List validationsMap = (List)data.get("itemValidations");
        this.itemValidations.clear();
        if (validationsMap != null) {
            for (Object obj : validationsMap) {
                Map validMap = (Map)obj;
                FBValidation validation = (FBValidation)decoder.decode(validMap);
                this.itemValidations.add(validation);
            }
        }
        List effectClassesObj = (List)data.get("effectClasses");
        this.effectClasses.clear();
        if (effectClassesObj != null) {
            for (Object obj : effectClassesObj) {
                this.effectClasses.add(obj.toString());
            }
        }
        this.eventActions.clear();
        Map eventActionsMap = (Map)data.get("eventActions");
        if (eventActionsMap != null) {
            for (Map.Entry entry : eventActionsMap.entrySet()) {
                Map scriptMap = (Map)entry.getValue();
                if (scriptMap != null) {
                    ScriptRepresentation script = new ScriptRepresentation();
                    script.setDataMap(scriptMap);
                    this.eventActions.put((String)entry.getKey(), script);
                    continue;
                }
                this.eventActions.put((String)entry.getKey(), (ScriptRepresentation)null);
            }
        }
        this.output = (OutputData)decoder.decode((Map)data.get("output"));
        this.input = (InputData)decoder.decode((Map)data.get("input"));
        this.external = (ExternalData)decoder.decode((Map)data.get("external"));
        this.width = (String)data.get("width");
        this.height = (String)data.get("height");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.effectClasses == null ? 0 : ((Object)this.effectClasses).hashCode());
        result = 31 * result + (this.eventActions == null ? 0 : ((Object)this.eventActions).hashCode());
        result = 31 * result + (this.external == null ? 0 : this.external.hashCode());
        result = 31 * result + (this.height == null ? 0 : this.height.hashCode());
        result = 31 * result + (this.input == null ? 0 : this.input.hashCode());
        result = 31 * result + (this.itemValidations == null ? 0 : ((Object)this.itemValidations).hashCode());
        result = 31 * result + (this.output == null ? 0 : this.output.hashCode());
        result = 31 * result + (this.typeId == null ? 0 : this.typeId.hashCode());
        result = 31 * result + (this.width == null ? 0 : this.width.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FormItemRepresentation other = (FormItemRepresentation)obj;
        if (this.effectClasses == null ? other.effectClasses != null : !((Object)this.effectClasses).equals(other.effectClasses)) {
            return false;
        }
        if (this.eventActions == null ? other.eventActions != null : !((Object)this.eventActions).equals(other.eventActions)) {
            return false;
        }
        if (this.external == null ? other.external != null : !this.external.equals(other.external)) {
            return false;
        }
        if (this.height == null ? other.height != null : !this.height.equals(other.height)) {
            return false;
        }
        if (this.input == null ? other.input != null : !this.input.equals(other.input)) {
            return false;
        }
        if (this.itemValidations == null ? other.itemValidations != null : !((Object)this.itemValidations).equals(other.itemValidations)) {
            return false;
        }
        if (this.output == null ? other.output != null : !this.output.equals(other.output)) {
            return false;
        }
        if (this.typeId == null ? other.typeId != null : !this.typeId.equals(other.typeId)) {
            return false;
        }
        return !(this.width == null ? other.width != null : !this.width.equals(other.width));
    }
}

