/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.error.filters;

import java.sql.SQLException;
import java.util.Date;
import javax.transaction.RollbackException;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.runtime.manager.impl.error.filters.AbstractExecutionErrorFilter;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.task.model.Task;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.internal.runtime.error.ExecutionErrorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBExecutionErrorFilter
extends AbstractExecutionErrorFilter {
    private static final Logger logger = LoggerFactory.getLogger(DBExecutionErrorFilter.class);
    private Class<?> hibernateException;

    public DBExecutionErrorFilter() {
        try {
            this.hibernateException = Class.forName("org.hibernate.HibernateException");
        }
        catch (Exception e) {
            logger.warn("Not able to find org.hibernate.HibernateException class");
        }
    }

    public boolean accept(ExecutionErrorContext errorContext) {
        return this.isCausedBy(errorContext.getCause(), new Class[]{SQLException.class, RollbackException.class, this.hibernateException});
    }

    public ExecutionError filter(ExecutionErrorContext errorContext) {
        ExecutionError.Builder errorBuilder = ExecutionError.builder().type("DB");
        String stacktrace = this.getStackTrace(errorContext.getCause());
        Task task = errorContext.getLastExecutedTask();
        NodeInstance nodeInstance = errorContext.getLastExecutedNode();
        logger.debug("Last executed node instance {}, last executed task {}", (Object)nodeInstance, (Object)task);
        if (nodeInstance != null) {
            logger.debug("Last executed node instance {} will be used to populate error details", (Object)nodeInstance);
            errorBuilder.deploymentId(((ProcessInstanceImpl)nodeInstance.getProcessInstance()).getDeploymentId()).processInstanceId(Long.valueOf(nodeInstance.getProcessInstance().getId())).processId(nodeInstance.getProcessInstance().getProcessId()).activityId(Long.valueOf(nodeInstance.getId())).activityName(this.nodeName(nodeInstance));
        } else if (task != null) {
            logger.debug("Last executed task {} will be used to populate error details", (Object)task);
            errorBuilder.deploymentId(task.getTaskData().getDeploymentId()).processInstanceId(Long.valueOf(task.getTaskData().getProcessInstanceId())).processId(task.getTaskData().getProcessId()).activityId(task.getId()).activityName(task.getName());
        }
        return errorBuilder.message(errorContext.getCause().getMessage()).error(stacktrace).errorDate(new Date()).build();
    }

    public Integer getPriority() {
        return 200;
    }

    public String toString() {
        return "DBExecutionErrorFilter [accepts=SQLException,HibernateException, ignores=]";
    }
}

