/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.Map;

import org.jbpm.pvm.Execution;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.client.ClientProcessDefinition;
import org.jbpm.pvm.client.ClientProcessInstance;
import org.jbpm.pvm.env.Environment;
import org.jbpm.pvm.session.PvmDbSession;

/**
 * @author Tom Baeyens
 */
public class StartExecutionCmd extends VariablesCmd<Execution> {

  private static final long serialVersionUID = 1L;
  
  protected String processDefinitionId;
  protected String executionKey;

  public StartExecutionCmd(String processDefinitionId, Map<String, Object> variables, String executionKey) {
    this.processDefinitionId = processDefinitionId;
    this.variables = variables;
    this.executionKey = executionKey;
  }

  public Execution execute(Environment environment) throws Exception {
    PvmDbSession pvmDbSession = environment.get(PvmDbSession.class);

    ClientProcessDefinition processDefinition = null;
    
    processDefinition = pvmDbSession.findProcessDefinitionById(processDefinitionId);
    if (processDefinition==null) {
      throw new PvmException("no process definition with id '"+processDefinitionId+"'");
    }
    
    ClientProcessInstance processInstance = processDefinition.createProcessInstance(executionKey);
    processInstance.setVariables(variables);
    processInstance.begin();
    
    pvmDbSession.save(processInstance);
    return processInstance;
  }

  public String getProcessDefinitionKey() {
    return processDefinitionId;
  }
  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionId = processDefinitionKey;
  }
  public String getExecutionKey() {
    return executionKey;
  }
  public void setExecutionKey(String executionKey) {
    this.executionKey = executionKey;
  }
}
