/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.pvm.internal.deploy;


import org.jbpm.pvm.Deployment;
import org.jbpm.pvm.ProcessDefinition;
import org.jbpm.pvm.PvmException;
import org.jbpm.pvm.internal.log.Log;


/** 
 * @author Tom Baeyens
 */
public class CreateProcess implements Deployer {
  
  private static final Log log = Log.getLog(CreateProcess.class.getName());
  
  protected Class<?> processDefinitionClass;
  
  public void deploy(Deployment deployment) {
    ProcessDefinition processDefinition = deployment.getProcessDefinition();
    
    if (processDefinition==null) {
      if (processDefinitionClass==null) {
        throw new PvmException("create-process deployer improperly configured: no class specified");
      }
      
      // instantiate
      try {
        log.trace("creating new "+processDefinitionClass.getName());
        processDefinition = (ProcessDefinition) processDefinitionClass.newInstance();
      } catch (Exception e) {
        throw new PvmException("couldn't instantiate process definition with class "+processDefinitionClass);
      }
      
      // make the process definition available in the deployment
      deployment.setProcessDefinition(processDefinition);

    } else {
      log.trace("using process definition provided in deployment");
    }
  }
}
